/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang3.StringUtils;
import org.nentangso.core.service.errors.NtsValidationException;

public class NtsValidationUtils {
    private NtsValidationUtils() {
    }

    public static <T> void validateObject(T entity) {
        NtsValidationUtils.validateObject(entity, null);
    }

    public static <T> void validateObject(T entity, String prefix) {
        Map<String, List<String>> errors = NtsValidationUtils.validateObjectAndGetErrors(entity, prefix);
        if (!errors.isEmpty()) {
            throw new NtsValidationException(errors);
        }
    }

    public static <T> Map<String, List<String>> validateObjectAndGetErrors(T entity, String prefix) {
        HashMap<String, List<String>> errors = new HashMap<String, List<String>>();
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set constraintViolations = validator.validate(entity, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            for (ConstraintViolation constraintViolation : constraintViolations) {
                String field = StringUtils.join((Object[])new String[]{prefix, constraintViolation.getPropertyPath().toString()});
                List messages = errors.getOrDefault(field, new ArrayList());
                messages.add(constraintViolation.getMessage());
                errors.putIfAbsent(field, messages);
            }
        }
        return errors;
    }
}

