/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.client;

import org.nentangso.core.client.NtsOAuth2ClientCredentialsRequestInterceptor;
import org.nentangso.core.config.NtsKeycloakLocationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.security.oauth2.client.AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import reactivefeign.client.ReactiveHttpRequestInterceptor;

public class NtsKeycloakFeignConfiguration {
    @Bean(name={"ntsKeycloakRequestInterceptor"})
    @Profile(value={"!testdev & !testprod"})
    public ReactiveHttpRequestInterceptor getOAuth2RequestInterceptor(ReactiveOAuth2AuthorizedClientManager authorizedClientManager, NtsKeycloakLocationProperties keycloakLocationProperties) {
        return new NtsOAuth2ClientCredentialsRequestInterceptor(authorizedClientManager, keycloakLocationProperties.getClientRegistrationId());
    }

    @Bean
    @Profile(value={"!testdev & !testprod"})
    public ReactiveOAuth2AuthorizedClientManager authorizedClientManager(ReactiveClientRegistrationRepository clientRegistrationRepository, ReactiveOAuth2AuthorizedClientService authorizedClientService) {
        return new AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientService);
    }
}

