/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.helper.location;

import java.util.Map;
import javax.cache.configuration.Configuration;
import org.nentangso.core.config.NtsProperties;
import org.nentangso.core.service.dto.NtsDefaultLocationDTO;
import org.redisson.api.RBucketReactive;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.SerializationCodec;
import org.redisson.jcache.configuration.RedissonConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@ConditionalOnProperty(prefix="nts.helper.location", name={"enabled"}, havingValue="true")
@Component
public class NtsDefaultLocationCacheable {
    private final NtsProperties ntsProperties;
    private final RedissonReactiveClient redissonClient;

    public NtsDefaultLocationCacheable(NtsProperties ntsProperties, Configuration<Object, Object> jcacheConfiguration) {
        this.ntsProperties = ntsProperties;
        this.redissonClient = ((RedissonConfiguration)jcacheConfiguration).getRedisson().reactive();
    }

    public Mono<Map<Long, NtsDefaultLocationDTO>> getCacheLocations() {
        if (!this.ntsProperties.getHelper().getLocation().getCache().isEnabled()) {
            return Mono.empty();
        }
        String cacheKey = this.generateCacheKey();
        RBucketReactive bucket = this.redissonClient.getBucket(cacheKey, (Codec)new SerializationCodec());
        return bucket.get();
    }

    private String generateCacheKey() {
        return this.ntsProperties.getHelper().getLocation().getCache().getKeyPrefix() + "locations_by_id";
    }

    public Mono<Map<Long, NtsDefaultLocationDTO>> setCacheLocations(Map<Long, NtsDefaultLocationDTO> items) {
        if (!this.ntsProperties.getHelper().getLocation().getCache().isEnabled()) {
            return Mono.just(items);
        }
        String cacheKey = this.generateCacheKey();
        RBucketReactive bucket = this.redissonClient.getBucket(cacheKey, (Codec)new SerializationCodec());
        return bucket.set(items).thenReturn(items);
    }
}

