/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.helper.location;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.nentangso.core.client.NtsHelperLocationRestClient;
import org.nentangso.core.service.dto.NtsDefaultLocationDTO;
import org.nentangso.core.service.helper.location.NtsDefaultLocationCacheable;
import org.nentangso.core.service.helper.location.NtsLocationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@ConditionalOnProperty(prefix="nts.helper.location", name={"provider"}, havingValue="org.nentangso.core.service.helper.location.NtsRestLocationProvider")
@Service
public class NtsRestLocationProvider
implements NtsLocationProvider<NtsDefaultLocationDTO> {
    private static final Logger log = LoggerFactory.getLogger(NtsRestLocationProvider.class);
    public static final String PROVIDER_NAME = "org.nentangso.core.service.helper.location.NtsRestLocationProvider";
    private final NtsDefaultLocationCacheable locationCacheable;
    private final NtsHelperLocationRestClient restClient;

    public NtsRestLocationProvider(NtsDefaultLocationCacheable locationCacheable, NtsHelperLocationRestClient restClient) {
        this.locationCacheable = locationCacheable;
        this.restClient = restClient;
    }

    @Override
    public Mono<Map<Long, NtsDefaultLocationDTO>> findAll() {
        return this.locationCacheable.getCacheLocations().switchIfEmpty(Mono.defer(() -> this.restClient.findAll().map(items -> items.stream().collect(Collectors.toMap(NtsDefaultLocationDTO::getId, v -> v))).flatMap(this.locationCacheable::setCacheLocations)));
    }

    @Override
    public Mono<Set<Long>> findAllIds() {
        return this.findAll().map(Map::keySet);
    }

    @Override
    public Mono<NtsDefaultLocationDTO> findById(Long id) {
        return this.findAll().flatMap(f -> Mono.justOrEmpty((Object)f.getOrDefault(id, null)));
    }
}

