/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.web.rest;

import java.util.ArrayList;
import java.util.List;
import org.nentangso.core.service.NtsUserService;
import org.nentangso.core.service.dto.NtsUserDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import tech.jhipster.web.util.PaginationUtil;

@RestController
@RequestMapping(value={"/api"})
@ConditionalOnMissingBean(name={"publicUserResource"})
public class NtsPublicUserResource {
    private final Logger log = LoggerFactory.getLogger(NtsPublicUserResource.class);
    private final NtsUserService userService;

    public NtsPublicUserResource(NtsUserService userService) {
        this.userService = userService;
    }

    @GetMapping(value={"/users"})
    public Mono<ResponseEntity<Flux<NtsUserDTO>>> getAllPublicUsers(ServerHttpRequest request, @ParameterObject Pageable pageable) {
        this.log.debug("REST request to get all public User names");
        return this.userService.countManagedUsers().map(total -> new PageImpl(new ArrayList(), pageable, total.longValue())).map(page -> PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)UriComponentsBuilder.fromHttpRequest((HttpRequest)request), (Page)page)).map(headers -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(this.userService.getAllPublicUsers(pageable)));
    }

    @GetMapping(value={"/authorities"})
    public Mono<List<String>> getAuthorities() {
        return this.userService.getAuthorities().collectList();
    }
}

