/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.browser;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.util.Charsets;
import org.neo4j.test.TestGraphDatabaseFactory;

public class CannedCypherExecutionTest {
    @Test
    public void shouldBeAbleToExecuteAllTheCannedCypherQueriesContainedInStaticHtmlFiles() throws Exception {
        URL resourceLoc = this.getClass().getClassLoader().getResource("browser");
        Assert.assertNotNull((Object)resourceLoc);
        final GraphDatabaseService database = new TestGraphDatabaseFactory().newImpermanentDatabase();
        final AtomicInteger cypherStatementCount = new AtomicInteger(0);
        Files.walkFileTree(Paths.get(resourceLoc.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                if (file.getFileName().toString().endsWith(".html")) {
                    String content = FileUtils.readTextFile((File)file.toFile(), (Charset)Charsets.UTF_8);
                    Elements cypherElements = Jsoup.parse((String)content).select("pre.runnable");
                    for (Element cypherElement : cypherElements) {
                        String statement = CannedCypherExecutionTest.this.replaceAngularExpressions(cypherElement.text());
                        if (statement.startsWith(":")) continue;
                        try (Transaction transaction = database.beginTx();){
                            database.execute(statement);
                            transaction.success();
                        }
                        catch (QueryExecutionException e) {
                            throw new AssertionError(String.format("Failed to execute query [%s] in file [%s]", statement, file), e);
                        }
                        cypherStatementCount.incrementAndGet();
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        Assert.assertTrue((String)"Static files should contain at least one valid cypher statement", (cypherStatementCount.intValue() > 0 ? 1 : 0) != 0);
        System.out.printf("Successfully executed %s cypher statements extracted from HTML files.%n", cypherStatementCount);
    }

    private String replaceAngularExpressions(String statement) {
        Pattern angularExpressionPattern = Pattern.compile("\\{\\{(.*?)}}");
        Matcher matcher = angularExpressionPattern.matcher(statement);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String expression = matcher.group(1);
            matcher.appendReplacement(buffer, this.chooseSuitableExpressionValue(expression));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String chooseSuitableExpressionValue(String expression) {
        return "relationshipDepth".equals(expression) ? "1" : "string";
    }
}

