/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.browser;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.Jsoup;
import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.impl.notification.NotificationCode;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.util.Charsets;
import org.neo4j.test.TestGraphDatabaseFactory;

public class CannedCypherExecutionTest {
    @Test
    public void shouldBeAbleToExecuteAllTheCannedCypherQueriesContainedInStaticHtmlFiles() throws Exception {
        URL resourceLoc = this.getClass().getClassLoader().getResource("browser");
        Assert.assertNotNull((Object)resourceLoc);
        final AtomicInteger explainCount = new AtomicInteger(0);
        final AtomicInteger executionCount = new AtomicInteger(0);
        Files.walkFileTree(Paths.get(resourceLoc.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                GraphDatabaseService database = new TestGraphDatabaseFactory().newImpermanentDatabase();
                String fileName = file.getFileName().toString();
                if (fileName.endsWith(".html")) {
                    String content = FileUtils.readTextFile((File)file.toFile(), (Charset)Charsets.UTF_8);
                    Elements cypherElements = Jsoup.parse((String)content).select("pre.runnable").not(".standalone-example");
                    for (Element cypherElement : cypherElements) {
                        Throwable throwable;
                        Transaction transaction;
                        String statement = CannedCypherExecutionTest.replaceAngularExpressions(cypherElement.text());
                        if (statement.startsWith(":")) continue;
                        if (CannedCypherExecutionTest.shouldExplain(statement)) {
                            try {
                                transaction = database.beginTx();
                                throwable = null;
                                try {
                                    boolean skipKnownInefficientCypher;
                                    Iterable actual = database.execute(CannedCypherExecutionTest.prependExplain(statement)).getNotifications();
                                    boolean bl = skipKnownInefficientCypher = !cypherElement.parent().select(".warn").isEmpty();
                                    if (skipKnownInefficientCypher) {
                                        ArrayList targetCollection = new ArrayList();
                                        CollectionUtils.addAll(targetCollection, (Iterable)actual);
                                        CollectionUtils.filter(targetCollection, (Predicate)new Predicate<Notification>(){

                                            public boolean evaluate(Notification notification) {
                                                return notification.getDescription().contains(NotificationCode.CARTESIAN_PRODUCT.values().toString());
                                            }
                                        });
                                        MatcherAssert.assertThat((String)String.format("Query [%s] should only produce cartesian product notifications. [%s]", statement, fileName), targetCollection, (Matcher)Matchers.empty());
                                        explainCount.incrementAndGet();
                                        transaction.success();
                                    } else {
                                        MatcherAssert.assertThat((String)String.format("Query [%s] should produce no notifications. [%s]", statement, fileName), (Object)actual, (Matcher)CoreMatchers.is((Matcher)Matchers.emptyIterable()));
                                        explainCount.incrementAndGet();
                                        transaction.success();
                                    }
                                }
                                catch (Throwable x2) {
                                    throwable = x2;
                                    throw x2;
                                }
                                finally {
                                    if (transaction != null) {
                                        if (throwable != null) {
                                            try {
                                                transaction.close();
                                            }
                                            catch (Throwable x2) {
                                                throwable.addSuppressed(x2);
                                            }
                                        } else {
                                            transaction.close();
                                        }
                                    }
                                }
                            }
                            catch (QueryExecutionException e) {
                                throw new AssertionError(String.format("Failed to explain query [%s] in file [%s]", statement, file), e);
                            }
                        }
                        try {
                            transaction = database.beginTx();
                            throwable = null;
                            try {
                                database.execute(statement);
                                executionCount.incrementAndGet();
                                transaction.success();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (transaction == null) continue;
                                if (throwable != null) {
                                    try {
                                        transaction.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                transaction.close();
                            }
                        }
                        catch (QueryExecutionException e) {
                            throw new AssertionError(String.format("Failed to execute query [%s] in file [%s]", statement, file), e);
                        }
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        Assert.assertTrue((String)"Static files should contain at least one valid cypher statement", (executionCount.intValue() >= 1 ? 1 : 0) != 0);
        System.out.printf("Explained %s cypher statements extracted from HTML files, with no notifications.%n", explainCount);
        System.out.printf("Executed %s cypher statements extracted from HTML files, with no errors.%n", executionCount);
    }

    private static String replaceAngularExpressions(String statement) {
        Pattern angularExpressionPattern = Pattern.compile("\\{\\{(.*?)}}");
        java.util.regex.Matcher matcher = angularExpressionPattern.matcher(statement);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String expression = matcher.group(1);
            matcher.appendReplacement(buffer, CannedCypherExecutionTest.chooseSuitableExpressionValue(expression));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static String chooseSuitableExpressionValue(String expression) {
        return "relationshipDepth".equals(expression) ? "1" : "string";
    }

    private static boolean shouldExplain(String statement) {
        return !CannedCypherExecutionTest.stripComments(statement).toUpperCase().startsWith("PROFILE");
    }

    private static String prependExplain(String statement) {
        if (!CannedCypherExecutionTest.stripComments(statement).toUpperCase().startsWith("EXPLAIN")) {
            return "EXPLAIN " + statement;
        }
        return statement;
    }

    private static String stripComments(String statement) {
        String[] lines = statement.replaceAll("/\\*.*\\*/", "").split("\n");
        ArrayList<String> nonCommentLines = new ArrayList<String>();
        for (String line : lines) {
            if (line.trim().startsWith("//")) continue;
            nonCommentLines.add(line);
        }
        return StringUtil.join(nonCommentLines, (String)"\n");
    }
}

