/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.browser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.test.TestGraphDatabaseFactory;

public class CsvExportImportRoundTripTest {
    @Test
    public void verifyThatCsvImportedWithLoadCsvThenSerialisedWithBrowserJavascriptIsIdenticalToTheOriginal() throws Exception {
        Path inputCsv = this.filePath("input.csv");
        Path exportJavascript = this.filePath("CsvExportImportRoundTripTest.js");
        GraphDatabaseService database = new TestGraphDatabaseFactory().newImpermanentDatabase();
        Result cypherResult = database.execute(String.format("LOAD CSV WITH HEADERS FROM 'file://%s' AS line RETURN line.col1 AS col1, line.col2 as col2, line.col3 as col3", inputCsv));
        String outputCsvString = this.exportCsvUsingNodeJs(this.asJsonString(cypherResult), exportJavascript);
        try (BufferedReader reader = new BufferedReader(new FileReader(inputCsv.toFile()));){
            String inputCsvString = this.readFully(reader);
            Assert.assertEquals((Object)inputCsvString, (Object)outputCsvString);
        }
    }

    private String asJsonString(Result cypherResult) throws IOException {
        HashMap<String, List> json = new HashMap<String, List>();
        json.put("columns", cypherResult.columns());
        ArrayList list = new ArrayList();
        while (cypherResult.hasNext()) {
            Map cypherRow = cypherResult.next();
            ArrayList cells = new ArrayList();
            for (String columnName : cypherResult.columns()) {
                cells.add(cypherRow.get(columnName));
            }
            list.add(cells);
        }
        json.put("rows", list);
        return new ObjectMapper().writeValueAsString(json);
    }

    private Path filePath(String filePath) throws URISyntaxException {
        URL resourceLoc = this.getClass().getClassLoader().getResource(filePath);
        Assert.assertNotNull((Object)resourceLoc);
        return Paths.get(resourceLoc.toURI());
    }

    private String exportCsvUsingNodeJs(String jsonString, Path path) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder("node", path.toString());
        Process process = processBuilder.start();
        OutputStreamWriter in = new OutputStreamWriter(process.getOutputStream());
        in.write(jsonString);
        ((Writer)in).close();
        int exitCode = process.waitFor();
        Assert.assertEquals((long)0L, (long)exitCode);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String string = this.readFully(reader);
            return string;
        }
    }

    private String readFully(BufferedReader reader) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }
}

