
/*!
Copyright (c) 2002-2015 "Neo Technology,"
Network Engine for Objects in Lund AB [http://neotechnology.com]

This file is part of Neo4j.

Neo4j is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
'use strict';
var neo,
  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

if (typeof global !== "undefined" && global !== null) {
  global.neo = global.neo || {};
}

if (typeof window !== "undefined" && window !== null) {
  window.neo = window.neo || {};
}

neo = (typeof global !== "undefined" && global !== null ? global.neo : void 0) || (typeof window !== "undefined" && window !== null ? window.neo : void 0);

neo.helpers = (function() {
  function helpers() {
    this.argv = function(input) {
      var rv;
      rv = input.toLowerCase().split(' ');
      return rv || [];
    };
    this.parseId = function(resource) {
      var id;
      if (resource == null) {
        resource = "";
      }
      id = resource.substr(resource.lastIndexOf("/") + 1);
      return parseInt(id, 10);
    };
    this.stripComments = function(input) {
      var j, len, row, rows, rv;
      rows = input.split("\n");
      rv = [];
      for (j = 0, len = rows.length; j < len; j++) {
        row = rows[j];
        if (row.indexOf('//') !== 0) {
          rv.push(row);
        }
      }
      return rv.join("\n");
    };
    this.firstWord = function(input) {
      return input.split(/\n| /)[0];
    };
    this.extendDeep = (function(_this) {
      return function(dst) {
        var index, key, obj, that, value;
        that = _this;
        for (index in arguments) {
          obj = arguments[index];
          if (obj !== dst) {
            for (key in obj) {
              value = obj[key];
              if (dst[key] && typeof dst[key] === 'object' && Object.getOwnPropertyNames(dst[key]).length > 0) {
                that.extendDeep(dst[key], value);
              } else if (typeof dst[key] !== 'function') {
                dst[key] = value;
              }
            }
          }
        }
        return dst;
      };
    })(this);
    this.extend = function(objects) {
      var extended, i, j, merge, obj, ref;
      extended = {};
      merge = function(obj) {
        var index, prop, results;
        results = [];
        for (index in obj) {
          prop = obj[index];
          if (Object.prototype.hasOwnProperty.call(obj, index)) {
            results.push(extended[index] = obj[index]);
          } else {
            results.push(void 0);
          }
        }
        return results;
      };
      merge(arguments[0]);
      for (i = j = 1, ref = arguments.length; 1 <= ref ? j < ref : j > ref; i = 1 <= ref ? ++j : --j) {
        obj = arguments[i];
        merge(obj);
      }
      return extended;
    };
    this.throttle = function(func, wait) {
      var last_timestamp, limit;
      last_timestamp = null;
      limit = wait;
      return function() {
        var args, context, now;
        context = this;
        args = arguments;
        now = Date.now();
        if (!last_timestamp || now - last_timestamp >= limit) {
          last_timestamp = now;
          return func.apply(context, args);
        }
      };
    };
    this.parseTimeMillis = (function(_this) {
      return function(timeWithOrWithoutUnit) {
        var unit, value;
        timeWithOrWithoutUnit += '';
        unit = timeWithOrWithoutUnit.match(/\D+/);
        value = parseInt(timeWithOrWithoutUnit);
        if ((unit != null ? unit.length : void 0) === 1) {
          switch (unit[0]) {
            case "ms":
              return value;
            case "s":
              return value * 1000;
            case "m":
              return value * 1000 * 60;
            default:
              return 0;
          }
        } else {
          return value * 1000;
        }
      };
    })(this);
    this.ua2text = function(ua) {
      var i, j, ref, s;
      s = '';
      for (i = j = 0, ref = ua.length; 0 <= ref ? j <= ref : j >= ref; i = 0 <= ref ? ++j : --j) {
        s = s + "" + String.fromCharCode(ua[i]);
      }
      return s;
    };
    this.escapeHTML = function(string) {
      var entityMap;
      entityMap = {
        "&": "&amp;",
        "<": "&lt;",
        ">": "&gt;",
        '"': '&quot;',
        "'": '&#39;',
        "/": '&#x2F;'
      };
      return String(string).replace(/[&<>"'\/]/g, function(s) {
        return entityMap[s];
      });
    };
    this.cleanHTML = function(string) {
      return this.stripNGAttributes(this.stripScripts(string));
    };
    this.stripScripts = function(string) {
      if (string == null) {
        string = '';
      }
      string = string.replace(/(\s+(on[^\s=]+)[^\s=]*\s*=\s*("[^"]*"|'[^']*'|[\w\-.:]+\s*))/ig, '');
      return string.replace(/<script\b[^<]*(?:(?!<\/script>)<[^<]*)*(<\/script>)?/gi, '');
    };
    this.stripNGAttributes = function(string) {
      if (string == null) {
        string = '';
      }
      return string.replace(/(\s+(ng|data|x)[^\s=]*\s*=\s*("[^"]*"|'[^']*'|[\w\-.:]+\s*))/ig, '');
    };
    this.hostIsAllowed = function(hostname, whitelist, is_enterprise) {
      var whitelisted_hosts;
      if (is_enterprise && (!whitelist || whitelist === '*')) {
        return true;
      }
      whitelisted_hosts = is_enterprise ? whitelist.split(",") : ['http://guides.neo4j.com', 'https://guides.neo4j.com', 'http://localhost', 'https://localhost'];
      return indexOf.call(whitelisted_hosts, hostname) >= 0;
    };
  }

  return helpers;

})();

/*!
Copyright (c) 2002-2015 "Neo Technology,"
Network Engine for Objects in Lund AB [http://neotechnology.com]

This file is part of Neo4j.

Neo4j is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
'use strict';
var neo;

if (typeof global !== "undefined" && global !== null) {
  global.neo = global.neo || {};
}

if (typeof window !== "undefined" && window !== null) {
  window.neo = window.neo || {};
}

neo = (typeof global !== "undefined" && global !== null ? global.neo : void 0) || (typeof window !== "undefined" && window !== null ? window.neo : void 0);

neo.serializer = (function() {
  function serializer(opts) {
    if (opts == null) {
      opts = {};
    }
    this.options = (new neo.helpers()).extend(opts, {
      delimiter: ','
    });
    this._output = "";
    this._columns = null;
    this.append = function(row) {
      var cell, ref;
      if (!Array.isArray(row) && row.length === ((ref = this._columns) != null ? ref.length : void 0)) {
        throw 'CSV: Row must an Array of column size';
      }
      this._output += "\n";
      return this._output += ((function() {
        var i, len, results;
        results = [];
        for (i = 0, len = row.length; i < len; i++) {
          cell = row[i];
          results.push(this._escape(cell));
        }
        return results;
      }).call(this)).join(this.options.delimiter);
    };
    this.columns = function(cols) {
      var c;
      if (cols == null) {
        return this._columns;
      }
      if (!Array.isArray(cols)) {
        throw 'CSV: Columns must an Array';
      }
      this._columns = (function() {
        var i, len, results;
        results = [];
        for (i = 0, len = cols.length; i < len; i++) {
          c = cols[i];
          results.push(this._escape(c));
        }
        return results;
      }).call(this);
      return this._output = this._columns.join(this.options.delimiter);
    };
    this.output = function() {
      return this._output;
    };
    this._escape = function(string) {
      if (string == null) {
        return '';
      }
      if (typeof string !== 'string') {
        string = JSON.stringify(string);
      }
      if (!string.length) {
        return '""';
      }
      if (string.indexOf(this.options.delimiter) > 0 || string.indexOf('"') >= 0) {
        string = '"' + string.replace(/"/g, '""') + '"';
      }
      return string;
    };
  }

  return serializer;

})();
/*
 * Copyright (c) 2002-2017 "Neo Technology,"
 * Network Engine for Objects in Lund AB [http://neotechnology.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 This file is for exporting data in CSV format into an outfile
 "/tmp/csv-export-javascript.csv" that could be read by other
 modules to test it's format.

 You have to include helpers.js and serializer.js before this file
 for it to work.

 e.g. `cat .tmp/lib/helpers.js .tmp/lib/serializer.js src/test/javascript/prepareCSVTest.js | node`
 */

var stdin = process.stdin,
    inputChunks = [];

stdin.resume();
stdin.setEncoding('utf8');

stdin.on('data', function(chunk) {
    inputChunks.push(chunk);
});

stdin.on('end', function() {
    var inputJSON = inputChunks.join(),
        parsedData = JSON.parse(inputJSON);

    var s = new neo.serializer();

    s.columns(parsedData.columns);
    parsedData.rows.forEach(function(row) {
        s.append(row);
    });
    process.stdout.write(s.output());
    process.stdout.write('\n');
});
