/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.advanced;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.advanced.AdvancedNeoServerBootstrapper;
import org.neo4j.server.advanced.jmx.ServerManagement;
import org.neo4j.server.helpers.ServerBuilder;

public class BootstrapperTest {
    @Test
    public void shouldBeAbleToRestartServer() throws Exception {
        String dbDir1 = new File("target/db1").getAbsolutePath();
        AdvancedNeoServerBootstrapper bs = new AdvancedNeoServerBootstrapper();
        System.setProperty("org.neo4j.server.properties", ServerBuilder.server().usingDatabaseDir(dbDir1).createPropertiesFiles().getAbsolutePath());
        bs.start(null);
        Assert.assertNotNull((Object)bs.getServer().getDatabase().graph);
        Assert.assertEquals((Object)dbDir1, (Object)bs.getServer().getDatabase().graph.getStoreDir());
        String dbDir2 = new File("target/db2").getAbsolutePath();
        System.setProperty("org.neo4j.server.properties", ServerBuilder.server().usingDatabaseDir(dbDir2).createPropertiesFiles().getAbsolutePath());
        ServerManagement bean = new ServerManagement((Bootstrapper)bs);
        bean.restartServer();
        Assert.assertEquals((Object)dbDir2, (Object)bs.getServer().getDatabase().graph.getStoreDir());
    }
}

