/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.advanced;

import java.io.File;
import org.apache.commons.configuration.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.NeoServer;
import org.neo4j.server.advanced.AdvancedNeoServer;
import org.neo4j.server.advanced.jmx.ServerManagement;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.test.TargetDirectory;

public class BootstrapperTest {
    @Test
    public void shouldBeAbleToRestartServer() throws Exception {
        TargetDirectory target = TargetDirectory.forTest(this.getClass());
        String dbDir1 = target.directory("db1", true).getAbsolutePath();
        PropertyFileConfigurator config = new PropertyFileConfigurator(ServerBuilder.server().usingDatabaseDir(dbDir1).createPropertiesFiles());
        File irrelevant = target.file("irrelevant");
        irrelevant.createNewFile();
        config.configuration().setProperty("org.neo4j.server.properties", (Object)irrelevant.getAbsolutePath());
        AdvancedNeoServer server = new AdvancedNeoServer((Configurator)config);
        server.start();
        Assert.assertNotNull((Object)server.getDatabase().getGraph());
        Assert.assertEquals((Object)dbDir1, (Object)server.getDatabase().getGraph().getStoreDir());
        String dbDir2 = target.directory("db2", true).getAbsolutePath();
        Configuration conf = config.configuration();
        conf.setProperty("org.neo4j.server.database.location", (Object)dbDir2);
        ServerManagement bean = new ServerManagement((NeoServer)server);
        bean.restartServer();
        Assert.assertEquals((Object)dbDir2, (Object)server.getDatabase().getGraph().getStoreDir());
    }
}

