/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.advanced.modules;

import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.NeoServer;
import org.neo4j.server.advanced.jmx.ServerManagement;
import org.neo4j.server.modules.ServerModule;

public class JMXManagementModule
implements ServerModule {
    private NeoServer server;

    public JMXManagementModule(NeoServer server) {
        this.server = server;
    }

    public void start(StringLogger logger) {
        try {
            ServerManagement serverManagement = new ServerManagement(this.server);
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            beanServer.registerMBean(serverManagement, this.createObjectName());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize jmx management, see nested exception.", e);
        }
    }

    public void stop() {
        try {
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            beanServer.unregisterMBean(this.createObjectName());
        }
        catch (InstanceNotFoundException e) {
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to shut down jmx management, see nested exception.", e);
        }
    }

    private ObjectName createObjectName() throws MalformedObjectNameException {
        return new ObjectName("org.neo4j.ServerManagement", "restartServer", "lifecycle");
    }
}

