/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.util.concurrent.Callable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.KernelData;
import org.neo4j.server.NeoServer;
import org.neo4j.server.advanced.helpers.AdvancedServerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.test.Mute;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class AdvancedVersionAndEditionServiceIT
extends ExclusiveServerTestBase {
    private static NeoServer server;
    private static FunctionalTestHelper functionalTestHelper;
    @ClassRule
    public static TemporaryFolder staticFolder;
    private static FakeClock clock;

    @BeforeClass
    public static void setupServer() throws Exception {
        clock = new FakeClock();
        server = AdvancedServerBuilder.server().usingDatabaseDir(staticFolder.getRoot().getAbsolutePath()).withClock((Clock)clock).build();
        Mute.muteAll().call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                server.start();
                return null;
            }
        });
        functionalTestHelper = new FunctionalTestHelper(server);
    }

    @Before
    public void setupTheDatabase() throws Exception {
    }

    @AfterClass
    public static void stopServer() throws Exception {
        Mute.muteAll().call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                server.stop();
                return null;
            }
        });
    }

    @Test
    public void shouldReportAdvancedEdition() throws Exception {
        String releaseVersion = ((KernelData)server.getDatabase().getGraph().getDependencyResolver().resolveDependency(KernelData.class)).version().getReleaseVersion();
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.managementUri() + "/" + "server/version");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.containsString((String)"edition: \"advanced\""));
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.containsString((String)("version: \"" + releaseVersion + "\"")));
    }

    static {
        staticFolder = new TemporaryFolder();
    }
}

