/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.advanced.helpers;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.advanced.AdvancedNeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.LoggingFactory;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.rest.web.DatabaseActions;

public class AdvancedServerBuilder
extends CommunityServerBuilder {
    public AdvancedServerBuilder(Logging logging) {
        super(LoggingFactory.given((Logging)logging));
    }

    public static AdvancedServerBuilder server(Logging logging) {
        return new AdvancedServerBuilder(logging);
    }

    public static AdvancedServerBuilder server() {
        return new AdvancedServerBuilder(null);
    }

    public AdvancedNeoServer build() throws IOException {
        return (AdvancedNeoServer)super.build();
    }

    public AdvancedNeoServer build(File configFile, Configurator configurator, Logging logging) {
        return new TestAdvancedNeoServer(configurator, configFile, logging);
    }

    private class TestAdvancedNeoServer
    extends AdvancedNeoServer {
        private final File configFile;

        public TestAdvancedNeoServer(Configurator propertyFileConfigurator, File configFile, Logging logging) {
            super(propertyFileConfigurator, LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)(AdvancedServerBuilder.this.persistent ? LifecycleManagingDatabase.EMBEDDED : CommunityServerBuilder.IN_MEMORY_DB)), logging);
            this.configFile = configFile;
        }

        protected PreFlightTasks createPreflightTasks() {
            return AdvancedServerBuilder.this.preflightTasks;
        }

        protected DatabaseActions createDatabaseActions() {
            return AdvancedServerBuilder.this.createDatabaseActionsObject(this.database, this.configurator);
        }

        public void stop() {
            super.stop();
            this.configFile.delete();
        }
    }
}

