/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.advanced.helpers;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.advanced.AdvancedNeoServer;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.web.DatabaseActions;

public class AdvancedServerBuilder
extends CommunityServerBuilder {
    private AdvancedServerBuilder(LogProvider userLogProvider) {
        super(userLogProvider);
    }

    public static AdvancedServerBuilder server(LogProvider userLogProvider) {
        return new AdvancedServerBuilder(userLogProvider);
    }

    public static AdvancedServerBuilder server() {
        return new AdvancedServerBuilder((LogProvider)NullLogProvider.getInstance());
    }

    public AdvancedNeoServer build() throws IOException {
        return (AdvancedNeoServer)super.build();
    }

    protected AdvancedNeoServer build(File configFile, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        return new TestAdvancedNeoServer(config, configFile, dependencies, this.logProvider);
    }

    private class TestAdvancedNeoServer
    extends AdvancedNeoServer {
        private final File configFile;

        public TestAdvancedNeoServer(Config config, File configFile, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
            super(config, LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)(AdvancedServerBuilder.this.persistent ? COMMUNITY_FACTORY : CommunityServerBuilder.IN_MEMORY_DB)), dependencies, logProvider);
            this.configFile = configFile;
        }

        protected DatabaseActions createDatabaseActions() {
            return AdvancedServerBuilder.this.createDatabaseActionsObject(this.database, this.getConfig());
        }

        public void stop() {
            super.stop();
            this.configFile.delete();
        }
    }
}

