/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import org.neo4j.causalclustering.core.CommercialCoreGraphDatabase;
import org.neo4j.causalclustering.readreplica.CommercialReadReplicaGraphDatabase;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.EnterpriseEditionSettings;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.enterprise.EnterpriseNeoServer;

public class CommercialNeoServer
extends EnterpriseNeoServer {
    private static final LifecycleManagingDatabase.GraphFactory CORE_FACTORY = (config, dependencies) -> {
        File storeDir = (File)config.get(DatabaseManagementSystemSettings.database_path);
        return new CommercialCoreGraphDatabase(storeDir, config, dependencies);
    };
    private static final LifecycleManagingDatabase.GraphFactory READ_REPLICA_FACTORY = (config, dependencies) -> {
        File storeDir = (File)config.get(DatabaseManagementSystemSettings.database_path);
        return new CommercialReadReplicaGraphDatabase(storeDir, config, dependencies);
    };

    public CommercialNeoServer(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
        super(config, CommercialNeoServer.createDbFactory(config), dependencies, logProvider);
    }

    protected static Database.Factory createDbFactory(Config config) {
        EnterpriseEditionSettings.Mode mode = (EnterpriseEditionSettings.Mode)config.get(EnterpriseEditionSettings.mode);
        switch (mode) {
            case CORE: {
                return LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)CORE_FACTORY);
            }
            case READ_REPLICA: {
                return LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)READ_REPLICA_FACTORY);
            }
        }
        return EnterpriseNeoServer.createDbFactory((Config)config);
    }
}

