/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.server.database.Database;
import org.neo4j.server.enterprise.ServerTestUtils;
import org.neo4j.server.rrd.JobScheduler;
import org.neo4j.server.rrd.RrdFactory;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;
import org.rrd4j.core.RrdDb;

public class TestHaDatabaseWithRrd {
    private LocalhostZooKeeperCluster zoo;

    @Before
    public void doBefore() throws Exception {
        this.zoo = LocalhostZooKeeperCluster.standardZoo(this.getClass());
    }

    @After
    public void doAfter() throws Exception {
        this.zoo.shutdown();
    }

    @Test
    @Ignore
    public void startHaGraphDatabaseWithRrd() throws Exception {
        String dir = TargetDirectory.forTest(this.getClass()).directory("rrd", true).getAbsolutePath();
        Map config = MapUtil.stringMap((String[])new String[]{HaSettings.server_id.name(), "1", HaSettings.coordinators.name(), this.zoo.getConnectionString()});
        Database db = new Database(ServerTestUtils.HA_GRAPH_DATABASE_FACTORY.createDatabase(dir, config));
        MapConfiguration dbConfig = new MapConfiguration(MapUtil.stringMap((String[])new String[]{"org.neo4j.server.webadmin.rrdb.location", new File(dir, "rrd").getAbsolutePath()}));
        RrdDb rrd = new RrdFactory((Configuration)dbConfig).createRrdDbAndSampler(db, this.noScheduling());
        db.setRrdDb(rrd);
        this.doTransaction(db);
        db.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransaction(Database db) {
        Node node = null;
        Transaction tx = db.graph.beginTx();
        String key = "name";
        String value = "Test";
        try {
            node = db.graph.createNode();
            node.setProperty(key, (Object)value);
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertEquals((Object)value, (Object)node.getProperty(key));
    }

    private JobScheduler noScheduling() {
        return new JobScheduler(){

            public void scheduleAtFixedRate(Runnable job, String jobName, long delay, long period) {
            }
        };
    }
}

