/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.server.advanced.AdvancedNeoServerBootstrapper;
import org.neo4j.server.database.GraphDatabaseFactory;
import org.neo4j.server.enterprise.Neo4jHAPropertiesMustExistRule;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckRule;

public class EnterpriseNeoServerBootstrapper
extends AdvancedNeoServerBootstrapper {
    public Iterable<StartupHealthCheckRule> getHealthCheckRules() {
        return new CombiningIterable(Arrays.asList(super.getHealthCheckRules(), Collections.singleton(new Neo4jHAPropertiesMustExistRule())));
    }

    protected GraphDatabaseFactory getGraphDatabaseFactory(Configuration configuration) {
        return DatabaseMode.valueOf(configuration.getString("org.neo4j.server.database.mode", DatabaseMode.SINGLE.name()).toUpperCase());
    }

    static enum DatabaseMode implements GraphDatabaseFactory
    {
        SINGLE{

            @Override
            public GraphDatabaseAPI createDatabase(String databaseStoreDirectory, Map<String, String> databaseProperties) {
                return new EmbeddedGraphDatabase(databaseStoreDirectory, databaseProperties);
            }
        }
        ,
        HA{

            @Override
            public GraphDatabaseAPI createDatabase(String databaseStoreDirectory, Map<String, String> databaseProperties) {
                return new HighlyAvailableGraphDatabase(databaseStoreDirectory, databaseProperties);
            }
        };


        public abstract GraphDatabaseAPI createDatabase(String var1, Map<String, String> var2);
    }
}

