/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.server.enterprise.EnterpriseNeoServerBootstrapper;
import org.neo4j.server.startup.healthcheck.Neo4jPropertiesMustExistRule;

public class Neo4jHAPropertiesMustExistRule
extends Neo4jPropertiesMustExistRule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateProperties(Properties configProperties) {
        String dbMode = configProperties.getProperty("org.neo4j.server.database.mode", EnterpriseNeoServerBootstrapper.DatabaseMode.SINGLE.name());
        if ((dbMode = dbMode.toUpperCase()).equals(EnterpriseNeoServerBootstrapper.DatabaseMode.SINGLE.name())) {
            return true;
        }
        if (!dbMode.equals(EnterpriseNeoServerBootstrapper.DatabaseMode.HA.name())) {
            this.failureMessage = String.format("Illegal value for %s \"%s\" in %s", "org.neo4j.server.database.mode", dbMode, "org.neo4j.server.properties");
            return false;
        }
        String dbTuningFilename = configProperties.getProperty("org.neo4j.server.db.tuning.properties");
        if (dbTuningFilename == null) {
            this.failureMessage = String.format("High-Availability mode requires %s to be set in %s", "org.neo4j.server.db.tuning.properties", "org.neo4j.server.properties");
            return false;
        }
        File dbTuningFile = new File(dbTuningFilename);
        if (!dbTuningFile.exists()) {
            this.failureMessage = String.format("No database tuning file at [%s]", dbTuningFile.getAbsoluteFile());
            return false;
        }
        Properties dbTuning = new Properties();
        try {
            FileInputStream tuningStream = new FileInputStream(dbTuningFile);
            try {
                dbTuning.load(tuningStream);
            }
            finally {
                ((InputStream)tuningStream).close();
            }
        }
        catch (IOException e) {
            this.failureMessage = e.getMessage();
            return false;
        }
        String machineId = null;
        try {
            machineId = this.getSinglePropertyFromCandidates(dbTuning, HaSettings.server_id.name(), "ha.machine_id", "<not set>");
            if (Integer.parseInt(machineId) < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.failureMessage = String.format("%s in %s needs to be a non-negative integer, not %s", HaSettings.server_id.name(), dbTuningFilename, machineId);
            return false;
        }
        catch (IllegalArgumentException e) {
            this.failureMessage = String.format("%s in %s", e.getMessage(), dbTuningFilename);
            return false;
        }
        String[] zkServers = null;
        try {
            zkServers = this.getSinglePropertyFromCandidates(dbTuning, HaSettings.coordinators.name(), "ha.zoo_keeper_servers", "").split(",");
        }
        catch (IllegalArgumentException e) {
            this.failureMessage = String.format("%s in %s", e.getMessage(), dbTuningFilename);
            return false;
        }
        if (zkServers.length <= 0) {
            this.failureMessage = String.format("%s in %s needs to specify at least one server", HaSettings.server_id.name(), dbTuningFilename);
            return false;
        }
        for (String zk : zkServers) {
            if (zk.contains(":")) continue;
            this.failureMessage = String.format("Invalid server config \"%s\" for %s in %s", zk, HaSettings.server_id.name(), dbTuningFilename);
            return false;
        }
        return true;
    }

    private String getSinglePropertyFromCandidates(Properties dbTuning, String first, String other, String defaultValue) {
        String firstValue = dbTuning.getProperty(first);
        String otherValue = dbTuning.getProperty(other);
        if (firstValue == null && otherValue == null) {
            return defaultValue;
        }
        if (firstValue != null && otherValue != null) {
            throw new IllegalArgumentException("Multiple configuration values set for the same logical property [" + first + "," + other + "]");
        }
        return firstValue != null ? firstValue : otherValue;
    }
}

