/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.server.enterprise.Neo4jHAPropertiesMustExistRule;
import org.neo4j.server.enterprise.ServerTestUtils;

public class Neo4jHAPropertiesMustExistRuleTest {
    @Test
    public void shouldPassIfHaModeNotSpecified() throws Exception {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("touch", "me", serverPropertyFile);
        this.assertRulePass(new Neo4jHAPropertiesMustExistRule(), serverPropertyFile);
    }

    @Test
    public void shouldFailIfInvalidModeSpecified() throws Exception {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "faulty", serverPropertyFile);
        this.assertRuleFail(new Neo4jHAPropertiesMustExistRule(), serverPropertyFile);
    }

    @Test
    public void shouldPassIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedAndExists() throws IOException {
        Neo4jHAPropertiesMustExistRule rule = new Neo4jHAPropertiesMustExistRule();
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        File dbTuningFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        ServerTestUtils.writePropertyToFile(HaSettings.server_id.name(), "1", dbTuningFile);
        ServerTestUtils.writePropertyToFile(HaSettings.coordinators.name(), "localhost:0000", dbTuningFile);
        this.assertRulePass(rule, serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldPassIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedAndExistsWithOldConfig() throws IOException {
        Neo4jHAPropertiesMustExistRule rule = new Neo4jHAPropertiesMustExistRule();
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        File dbTuningFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        ServerTestUtils.writePropertyToFile("ha.machine_id", "1", dbTuningFile);
        ServerTestUtils.writePropertyToFile("ha.zoo_keeper_servers", "localhost:0000", dbTuningFile);
        this.assertRulePass(rule, serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldFailIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedAndExistsWithDuplicateIdConfig() throws IOException {
        Neo4jHAPropertiesMustExistRule rule = new Neo4jHAPropertiesMustExistRule();
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        File dbTuningFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        ServerTestUtils.writePropertyToFile("ha.machine_id", "1", dbTuningFile);
        ServerTestUtils.writePropertyToFile(HaSettings.server_id.name(), "1", dbTuningFile);
        ServerTestUtils.writePropertyToFile(HaSettings.coordinators.name(), "localhost:0000", dbTuningFile);
        this.assertRuleFail(rule, serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldFailIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedAndExistsWithDuplicateCoordinatorConfig() throws IOException {
        Neo4jHAPropertiesMustExistRule rule = new Neo4jHAPropertiesMustExistRule();
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        File dbTuningFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        ServerTestUtils.writePropertyToFile(HaSettings.server_id.name(), "1", dbTuningFile);
        ServerTestUtils.writePropertyToFile(HaSettings.coordinators.name(), "localhost:0000", dbTuningFile);
        ServerTestUtils.writePropertyToFile("ha.zoo_keeper_servers", "localhost:0000", dbTuningFile);
        this.assertRuleFail(rule, serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldFailIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedButDoesNotExist() throws IOException {
        Neo4jHAPropertiesMustExistRule rule = new Neo4jHAPropertiesMustExistRule();
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        File dbTuningFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        this.assertRuleFail(rule, serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldFailIfHAModeIsSetAndTheDbTuningFileHasNotBeenSpecified() throws IOException {
        Neo4jHAPropertiesMustExistRule rule = new Neo4jHAPropertiesMustExistRule();
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        this.assertRuleFail(rule, serverPropertyFile);
        serverPropertyFile.delete();
    }

    private void assertRulePass(Neo4jHAPropertiesMustExistRule rule, File propFile) {
        if (!rule.execute(this.propertiesWithConfigFileLocation(propFile))) {
            Assert.fail((String)rule.getFailureMessage());
        }
    }

    private void assertRuleFail(Neo4jHAPropertiesMustExistRule rule, File propFile) {
        if (rule.execute(this.propertiesWithConfigFileLocation(propFile))) {
            Assert.fail((String)(rule + " should have failed"));
        }
    }

    private Properties propertiesWithConfigFileLocation(File propertyFile) {
        Properties result = new Properties();
        result.setProperty("org.neo4j.server.properties", propertyFile.getAbsolutePath());
        return result;
    }
}

