/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.CommunityDatabase;

public class EnterpriseDatabase
extends CommunityDatabase {
    public EnterpriseDatabase(Configurator configurator, Logging logging) {
        super(configurator, logging);
    }

    public void start() throws Throwable {
        try {
            DatabaseMode factory = DatabaseMode.valueOf(this.serverConfiguration.getString("org.neo4j.server.database.mode", DatabaseMode.SINGLE.name()).toUpperCase());
            this.graph = (AbstractGraphDatabase)factory.createDatabase(this.serverConfiguration.getString("org.neo4j.server.database.location", "data/graph.db"), this.getDbTuningPropertiesWithServerDefaults());
            this.log.log("Successfully started database");
        }
        catch (Exception e) {
            this.log.error("Failed to start database.", (Throwable)e);
            throw e;
        }
    }

    static enum DatabaseMode implements org.neo4j.server.database.GraphDatabaseFactory
    {
        SINGLE{

            @Override
            public GraphDatabaseAPI createDatabase(String databaseStoreDirectory, Map<String, String> databaseProperties) {
                return (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(databaseStoreDirectory).setConfig(databaseProperties).newGraphDatabase();
            }
        }
        ,
        HA{

            @Override
            public GraphDatabaseAPI createDatabase(String databaseStoreDirectory, Map<String, String> databaseProperties) {
                return (GraphDatabaseAPI)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(databaseStoreDirectory).setConfig(databaseProperties).newGraphDatabase();
            }
        };


        public abstract GraphDatabaseAPI createDatabase(String var1, Map<String, String> var2);
    }
}

