/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.util.Arrays;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.InterruptThreadTimer;
import org.neo4j.server.advanced.AdvancedNeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.Database;
import org.neo4j.server.enterprise.EnterpriseDatabase;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.preflight.EnsurePreparedForHttpLogging;
import org.neo4j.server.preflight.PerformRecoveryIfNecessary;
import org.neo4j.server.preflight.PerformUpgradeIfNecessary;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightTask;
import org.neo4j.server.webadmin.rest.AdvertisableService;
import org.neo4j.server.webadmin.rest.MasterInfoServerModule;
import org.neo4j.server.webadmin.rest.MasterInfoService;

public class EnterpriseNeoServer
extends AdvancedNeoServer {
    public EnterpriseNeoServer(Configurator configurator, Logging logging) {
        super(logging);
        this.configurator = configurator;
        this.init();
    }

    protected PreFlightTasks createPreflightTasks() {
        return new PreFlightTasks(this.logging, new PreflightTask[]{new EnsurePreparedForHttpLogging(this.configurator.configuration()), new PerformUpgradeIfNecessary(this.getConfiguration(), this.configurator.getDatabaseTuningProperties(), System.out, this.logging), new PerformRecoveryIfNecessary(this.getConfiguration(), this.configurator.getDatabaseTuningProperties(), System.out, this.logging)});
    }

    protected Database createDatabase() {
        return new EnterpriseDatabase(this.configurator, this.logging);
    }

    protected Iterable<ServerModule> createServerModules() {
        return Iterables.mix((Iterable[])new Iterable[]{Arrays.asList(new MasterInfoServerModule(this.webServer, this.getConfiguration(), this.logging)), super.createServerModules()});
    }

    protected InterruptThreadTimer createInterruptStartupTimer() {
        if (this.getConfiguration().getString("org.neo4j.server.database.mode", "single").equalsIgnoreCase("ha")) {
            long startupTimeout = this.getConfiguration().getInt("org.neo4j.server.startup_timeout", 0) * 1000;
            InterruptThreadTimer stopStartupTimer = startupTimeout > 0L ? InterruptThreadTimer.createTimer((long)startupTimeout, (Thread)Thread.currentThread()) : InterruptThreadTimer.createNoOpTimer();
            return stopStartupTimer;
        }
        return super.createInterruptStartupTimer();
    }

    public Iterable<AdvertisableService> getServices() {
        if (this.getDatabase().getGraph() instanceof HighlyAvailableGraphDatabase) {
            return Iterables.append((Object)new MasterInfoService(null, null), (Iterable)super.getServices());
        }
        return super.getServices();
    }
}

