/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.helpers;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.logging.BufferingConsoleLogger;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.validation.DatabaseLocationMustBeSpecifiedRule;
import org.neo4j.server.configuration.validation.ValidationRule;
import org.neo4j.server.configuration.validation.Validator;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.EphemeralDatabase;
import org.neo4j.server.enterprise.EnterpriseNeoServer;
import org.neo4j.server.helpers.LoggingFactory;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.rest.web.DatabaseActions;

public class EnterpriseServerBuilder
extends ServerBuilder {
    protected EnterpriseServerBuilder(LoggingFactory loggingFactory) {
        super(loggingFactory);
    }

    public static EnterpriseServerBuilder server() {
        return EnterpriseServerBuilder.server(LoggingFactory.IMPERMANENT_LOGGING);
    }

    public static EnterpriseServerBuilder server(LoggingFactory loggingFactory) {
        return new EnterpriseServerBuilder(loggingFactory);
    }

    public EnterpriseNeoServer build() throws IOException {
        if (this.dbDir == null) {
            this.dbDir = ServerTestUtils.createTempDir().getAbsolutePath();
        }
        File configFile = this.buildBefore();
        BufferingConsoleLogger console = new BufferingConsoleLogger();
        Validator validator = new Validator(new ValidationRule[]{new DatabaseLocationMustBeSpecifiedRule()});
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(validator, configFile, (ConsoleLogger)console);
        Logging logging = this.loggingFactory.create((Configurator)configurator);
        console.replayInto(logging.getConsoleLog(((Object)((Object)this)).getClass()));
        return new EnterpriseNeoServer((Configurator)configurator, logging){

            protected PreFlightTasks createPreflightTasks() {
                return EnterpriseServerBuilder.this.preflightTasks;
            }

            protected Database createDatabase() {
                return EnterpriseServerBuilder.this.persistent ? super.createDatabase() : new EphemeralDatabase(this.configurator);
            }

            protected DatabaseActions createDatabaseActions() {
                return EnterpriseServerBuilder.this.createDatabaseActionsObject(this.database, this.configurator);
            }
        };
    }
}

