/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.net.URI;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.JAXRSHelper;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;
import org.neo4j.server.webadmin.rest.MasterInfoService;

public class MasterInfoServerModule
implements ServerModule {
    private final WebServer server;
    private final Configuration config;
    private final ConsoleLogger log;

    public MasterInfoServerModule(WebServer server, Configuration config, Logging logging) {
        this.server = server;
        this.config = config;
        this.log = logging.getConsoleLog(this.getClass());
    }

    public void start() {
        URI baseUri = this.managementApiUri();
        this.server.addJAXRSClasses(this.getClassNames(), baseUri.toString(), null);
        this.log.log("Mounted REST API at: " + baseUri.toString());
    }

    public void stop() {
        URI baseUri = this.managementApiUri();
        this.server.removeJAXRSClasses(this.getClassNames(), baseUri.toString());
    }

    private List<String> getClassNames() {
        return JAXRSHelper.listFrom((String[])new String[]{MasterInfoService.class.getName()});
    }

    private URI managementApiUri() {
        return URI.create(this.config.getString("org.neo4j.server.webadmin.management.uri", "/db/manage"));
    }
}

