/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.webadmin.rest.AdvertisableService;
import org.neo4j.server.webadmin.rest.HaDiscoveryRepresentation;

@Path(value="server/ha")
public class MasterInfoService
implements AdvertisableService {
    public static final String BASE_PATH = "server/ha";
    public static final String IS_MASTER_PATH = "/master";
    public static final String IS_SLAVE_PATH = "/slave";
    public static final String IS_AVAILABLE_PATH = "/available";
    private final OutputFormat output;
    private final HighlyAvailableGraphDatabase haDb;

    public MasterInfoService(@Context OutputFormat output, @Context GraphDatabaseService db) {
        this.output = output;
        this.haDb = db instanceof HighlyAvailableGraphDatabase ? (HighlyAvailableGraphDatabase)db : null;
    }

    @GET
    public Response discover() throws BadInputException {
        if (this.haDb == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String isMasterUri = IS_MASTER_PATH;
        String isSlaveUri = IS_SLAVE_PATH;
        HaDiscoveryRepresentation dr = new HaDiscoveryRepresentation(BASE_PATH, isMasterUri, isSlaveUri);
        return this.output.ok((Representation)dr);
    }

    @GET
    @Path(value="/master")
    public Response isMaster() throws BadInputException {
        if (this.haDb == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String role = this.haDb.role().toLowerCase();
        if (role.equals("master")) {
            return this.positiveResponse();
        }
        if (role.equals("slave")) {
            return this.negativeResponse();
        }
        return this.unknownResponse();
    }

    @GET
    @Path(value="/slave")
    public Response isSlave() throws BadInputException {
        if (this.haDb == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String role = this.haDb.role().toLowerCase();
        if (role.equals("slave")) {
            return this.positiveResponse();
        }
        if (role.equals("master")) {
            return this.negativeResponse();
        }
        return this.unknownResponse();
    }

    @GET
    @Path(value="/available")
    public Response isAvailable() {
        if (this.haDb == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String role = this.haDb.role().toLowerCase();
        if ("slave".equals(role) || "master".equals(role)) {
            return this.plainTextResponse(Response.Status.OK, role);
        }
        return this.unknownResponse();
    }

    private Response negativeResponse() {
        return this.plainTextResponse(Response.Status.NOT_FOUND, "false");
    }

    private Response positiveResponse() {
        return this.plainTextResponse(Response.Status.OK, "true");
    }

    private Response unknownResponse() {
        return this.plainTextResponse(Response.Status.NOT_FOUND, "UNKNOWN");
    }

    private Response plainTextResponse(Response.Status status, String entityBody) {
        return Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)entityBody).build();
    }

    public String getName() {
        return "ha";
    }

    public String getServerPath() {
        return BASE_PATH;
    }
}

