/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.enterprise.EnsureEnterpriseNeo4jPropertiesExist;
import org.neo4j.server.enterprise.ServerTestUtils;

public class Neo4jHAPropertiesMustExistRuleTest {
    public static final String CONFIG_KEY_OLD_SERVER_ID = "ha.machine_id";
    public static final String CONFIG_KEY_OLD_COORDINATORS = "ha.zoo_keeper_servers";

    @Test
    public void shouldPassIfHaModeNotSpecified() throws Exception {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("touch", "me", serverPropertyFile);
        this.assertRulePass(serverPropertyFile);
    }

    @Test
    public void shouldFailIfInvalidModeSpecified() throws Exception {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "faulty", serverPropertyFile);
        this.assertRuleFail(serverPropertyFile);
    }

    @Test
    public void shouldPassIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedAndExists() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        File dbTuningFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        ServerTestUtils.writePropertyToFile(HaSettings.server_id.name(), "1", dbTuningFile);
        this.assertRulePass(serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldPassIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedAndExistsWithOldConfig() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        File dbTuningFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        ServerTestUtils.writePropertyToFile(CONFIG_KEY_OLD_SERVER_ID, "1", dbTuningFile);
        ServerTestUtils.writePropertyToFile(CONFIG_KEY_OLD_COORDINATORS, "localhost:0000", dbTuningFile);
        this.assertRulePass(serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldFailIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedAndExistsWithDuplicateIdConfig() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        File dbTuningFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        ServerTestUtils.writePropertyToFile(CONFIG_KEY_OLD_SERVER_ID, "1", dbTuningFile);
        ServerTestUtils.writePropertyToFile(HaSettings.server_id.name(), "1", dbTuningFile);
        this.assertRuleFail(serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldFailIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedButDoesNotExist() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        File dbTuningFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        this.assertRuleFail(serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldFailIfHAModeIsSetAndTheDbTuningFileHasNotBeenSpecified() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile();
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        this.assertRuleFail(serverPropertyFile);
        serverPropertyFile.delete();
    }

    private void assertRulePass(File file) {
        EnsureEnterpriseNeo4jPropertiesExist rule = new EnsureEnterpriseNeo4jPropertiesExist(this.propertiesWithConfigFileLocation(file));
        if (!rule.run()) {
            Assert.fail((String)rule.getFailureMessage());
        }
    }

    private void assertRuleFail(File file) {
        EnsureEnterpriseNeo4jPropertiesExist rule = new EnsureEnterpriseNeo4jPropertiesExist(this.propertiesWithConfigFileLocation(file));
        if (rule.run()) {
            Assert.fail((String)(rule + " should have failed"));
        }
    }

    private Configuration propertiesWithConfigFileLocation(File propertyFile) {
        PropertyFileConfigurator config = new PropertyFileConfigurator(propertyFile);
        config.configuration().setProperty("org.neo4j.server.properties", (Object)propertyFile.getAbsolutePath());
        return config.configuration();
    }
}

