/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.ServerIdElectionCredentialsProvider;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.enterprise.StandaloneClusterClient;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.TargetDirectory;

public class StandaloneClusterClientIT {
    private File directory = TargetDirectory.forTest(this.getClass()).directory("temp", true);
    private LifeSupport life;
    private ClusterClient[] clients;

    @Test
    public void canJoinWithExplicitInitialHosts() throws Exception {
        this.startAndAssertJoined(5003, null, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5001"}));
    }

    @Test
    public void willFailJoinIfIncorrectInitialHostsSet() throws Exception {
        this.startAndAssertJoined(null, null, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5011"}));
    }

    @Test
    public void canJoinWithInitialHostsInConfigFile() throws Exception {
        this.startAndAssertJoined(5003, this.configFile(ClusterSettings.initial_hosts.name(), ":5001"), MapUtil.stringMap((String[])new String[0]));
    }

    @Test
    public void willFailJoinIfIncorrectInitialHostsSetInConfigFile() throws Exception {
        this.startAndAssertJoined(null, this.configFile(ClusterSettings.initial_hosts.name(), ":5011"), MapUtil.stringMap((String[])new String[0]));
    }

    @Test
    public void canOverrideInitialHostsConfigFromConfigFile() throws Exception {
        this.startAndAssertJoined(5003, this.configFile(ClusterSettings.initial_hosts.name(), ":5011"), MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5001"}));
    }

    @Test
    public void canSetSpecificPort() throws Exception {
        this.startAndAssertJoined(5010, null, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5001", ClusterSettings.cluster_server.name(), ":5010"}));
    }

    @Test
    public void usesPortRangeFromConfigFile() throws Exception {
        this.startAndAssertJoined(5012, this.configFile(ClusterSettings.initial_hosts.name(), ":5001", ClusterSettings.cluster_server.name(), ":5012-5020"), MapUtil.stringMap((String[])new String[0]));
    }

    @Before
    public void before() throws Exception {
        this.life = new LifeSupport();
        this.life.start();
        this.clients = new ClusterClient[2];
        for (int i = 1; i <= this.clients.length; ++i) {
            Map config = MapUtil.stringMap((String[])new String[0]);
            config.put(ClusterSettings.cluster_server.name(), ":" + (5000 + i));
            config.put(HaSettings.server_id.name(), "" + i);
            config.put(ClusterSettings.initial_hosts.name(), ":5001");
            Logging logging = new Logging(){

                public StringLogger getLogger(Class loggingClass) {
                    return StringLogger.SYSTEM;
                }
            };
            final ClusterClient client = new ClusterClient(ClusterClient.adapt((Config)new Config(config)), logging, (ElectionCredentialsProvider)new ServerIdElectionCredentialsProvider());
            final CountDownLatch latch = new CountDownLatch(1);
            client.addClusterListener((ClusterListener)new ClusterListener.Adapter(){

                public void enteredCluster(ClusterConfiguration configuration) {
                    latch.countDown();
                    client.removeClusterListener((ClusterListener)this);
                }
            });
            this.clients[i - 1] = (ClusterClient)this.life.add((Object)client);
            Assert.assertTrue((String)"Didn't join the cluster", (boolean)latch.await(2L, TimeUnit.SECONDS));
        }
    }

    @After
    public void after() throws Exception {
        this.life.shutdown();
    }

    private File configFile(Object ... settingsAndValues) throws IOException {
        File directory = TargetDirectory.forTest(this.getClass()).directory("temp", true);
        File dbConfigFile = new File(directory, "config-file");
        MapUtil.store((Map)MapUtil.genericMap((Object[])settingsAndValues), (File)dbConfigFile);
        File serverConfigFile = new File(directory, "server-file");
        MapUtil.store((Map)MapUtil.stringMap((String[])new String[]{"org.neo4j.server.db.tuning.properties", dbConfigFile.getAbsolutePath()}), (File)serverConfigFile);
        return serverConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAndAssertJoined(Integer expectedPort, File configFile, Map<String, String> config) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger port = new AtomicInteger();
        this.clients[0].addClusterListener((ClusterListener)new ClusterListener.Adapter(){

            public void joinedCluster(URI member) {
                port.set(member.getPort());
                latch.countDown();
                StandaloneClusterClientIT.this.clients[0].removeClusterListener((ClusterListener)this);
            }
        });
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("java", "-cp", System.getProperty("java.class.path")));
        args.add("-Dneo4j.home=" + this.directory.getAbsolutePath());
        if (configFile != null) {
            args.add("-Dorg.neo4j.server.properties=" + configFile.getAbsolutePath());
        }
        args.add(StandaloneClusterClient.class.getName());
        for (Map.Entry<String, String> entry : config.entrySet()) {
            args.add("-" + entry.getKey() + "=" + entry.getValue());
        }
        Process process = Runtime.getRuntime().exec(args.toArray(new String[0]));
        ProcessStreamHandler handler = new ProcessStreamHandler(process, false);
        handler.launch();
        try {
            boolean awaitOutcome = latch.await(5L, TimeUnit.SECONDS);
            if (expectedPort == null) {
                Assert.assertFalse((boolean)awaitOutcome);
            } else {
                Assert.assertTrue((boolean)awaitOutcome);
                Assert.assertEquals((long)expectedPort.intValue(), (long)port.get());
            }
        }
        finally {
            process.destroy();
        }
    }
}

