/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.functional;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.enterprise.EnterpriseDatabase;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;

public class EnterpriseServerIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToStartInHAMode() throws Throwable {
        File tuningFile = this.createNeo4jProperties();
        CommunityNeoServer server = EnterpriseServerBuilder.server().withProperty("org.neo4j.server.database.mode", "HA").withProperty("org.neo4j.server.db.tuning.properties", tuningFile.getAbsolutePath()).persistent().build();
        try {
            server.start();
            Assert.assertThat((Object)server.getDatabase(), (Matcher)CoreMatchers.is(EnterpriseDatabase.class));
            Assert.assertThat((Object)server.getDatabase().getGraph(), (Matcher)CoreMatchers.is(HighlyAvailableGraphDatabase.class));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createNeo4jProperties() throws IOException, FileNotFoundException {
        File tuningFile = File.createTempFile("neo4j-test", "properties");
        FileOutputStream fos = new FileOutputStream(tuningFile);
        try {
            Properties neo4jProps = new Properties();
            neo4jProps.put("ha.server_id", "1");
            neo4jProps.store(fos, "");
            File file = tuningFile;
            return file;
        }
        finally {
            fos.close();
        }
    }
}

