/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import org.neo4j.server.InterruptThreadTimer;
import org.neo4j.server.advanced.AdvancedNeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.Database;
import org.neo4j.server.enterprise.EnterpriseDatabase;
import org.neo4j.server.preflight.EnsurePreparedForHttpLogging;
import org.neo4j.server.preflight.PerformRecoveryIfNecessary;
import org.neo4j.server.preflight.PerformUpgradeIfNecessary;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightTask;

public class EnterpriseNeoServer
extends AdvancedNeoServer {
    public EnterpriseNeoServer(Configurator configurator) {
        this.configurator = configurator;
        this.init();
    }

    protected PreFlightTasks createPreflightTasks() {
        return new PreFlightTasks(new PreflightTask[]{new EnsurePreparedForHttpLogging(this.configurator.configuration()), new PerformUpgradeIfNecessary(this.getConfiguration(), this.configurator.getDatabaseTuningProperties(), System.out), new PerformRecoveryIfNecessary(this.getConfiguration(), this.configurator.getDatabaseTuningProperties(), System.out)});
    }

    protected Database createDatabase() {
        return new EnterpriseDatabase(this.configurator.configuration());
    }

    protected InterruptThreadTimer createInterruptStartupTimer() {
        if (this.getConfiguration().getString("org.neo4j.server.database.mode", "single").equalsIgnoreCase("ha")) {
            long startupTimeout = this.getConfiguration().getInt("org.neo4j.server.startup_timeout", 0) * 1000;
            InterruptThreadTimer stopStartupTimer = startupTimeout > 0L ? InterruptThreadTimer.createTimer((long)startupTimeout, (Thread)Thread.currentThread()) : InterruptThreadTimer.createNoOpTimer();
            return stopStartupTimer;
        }
        return super.createInterruptStartupTimer();
    }
}

