/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.helpers;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.validation.DatabaseLocationMustBeSpecifiedRule;
import org.neo4j.server.configuration.validation.ValidationRule;
import org.neo4j.server.configuration.validation.Validator;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.EphemeralDatabase;
import org.neo4j.server.enterprise.EnterpriseNeoServer;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.paging.RealClock;
import org.neo4j.server.rest.web.DatabaseActions;

public class EnterpriseServerBuilder
extends ServerBuilder {
    public static EnterpriseServerBuilder server() {
        return new EnterpriseServerBuilder();
    }

    public EnterpriseNeoServer build() throws IOException {
        if (this.dbDir == null) {
            this.dbDir = ServerTestUtils.createTempDir().getAbsolutePath();
        }
        File configFile = this.createPropertiesFiles();
        return new EnterpriseNeoServer((Configurator)new PropertyFileConfigurator(new Validator(new ValidationRule[]{new DatabaseLocationMustBeSpecifiedRule()}), configFile)){

            protected PreFlightTasks createPreflightTasks() {
                return EnterpriseServerBuilder.this.preflightTasks;
            }

            protected Database createDatabase() {
                return EnterpriseServerBuilder.this.persistent ? super.createDatabase() : new EphemeralDatabase(this.configurator.configuration());
            }

            protected DatabaseActions createDatabaseActions() {
                RealClock clockToUse = EnterpriseServerBuilder.this.clock != null ? EnterpriseServerBuilder.this.clock : new RealClock();
                return new DatabaseActions(this.database, new LeaseManager(EnterpriseServerBuilder.this.clock), ForceMode.forced, this.configurator.configuration().getBoolean("org.neo4j.server.script.sandboxing.enabled", Configurator.DEFAULT_SCRIPT_SANDBOXING_ENABLED).booleanValue());
            }
        };
    }
}

