/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.webadmin.rest.AdvertisableService;
import org.neo4j.server.webadmin.rest.HaDiscoveryRepresentation;

@Path(value="/server/ha")
public class MasterInfoService
implements AdvertisableService {
    public static final String BASE_PATH = "/server/ha";
    public static final String ISMASTER_PATH = "/isMaster";
    public static final String GETMASTER_PATH = "/getMaster";
    private final OutputFormat output;
    private final HighlyAvailableGraphDatabase haDb;

    public MasterInfoService(@Context OutputFormat output, @Context GraphDatabaseService db) {
        this.output = output;
        this.haDb = db instanceof HighlyAvailableGraphDatabase ? (HighlyAvailableGraphDatabase)db : null;
    }

    @GET
    public Response discover() throws BadInputException {
        if (this.haDb == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String isMasterUri = "isMaster";
        String getMasterUri = "getMaster";
        HaDiscoveryRepresentation dr = new HaDiscoveryRepresentation(isMasterUri, getMasterUri);
        return this.output.ok((Representation)dr);
    }

    @GET
    @Path(value="/isMaster")
    public Response isMaster() throws BadInputException {
        if (this.haDb == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (this.haDb.isMaster()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)Boolean.toString(true).getBytes()).build();
        }
        return Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)Boolean.toString(false).getBytes()).header("Location", (Object)this.getMasterUriAsString()).build();
    }

    @GET
    @Path(value="/getMaster")
    public Response getMaster() throws BadInputException {
        if (this.haDb == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String masterURI = this.getMasterUriAsString();
        return Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)Boolean.toString(false).getBytes()).header("Location", (Object)masterURI).build();
    }

    private String getMasterUriAsString() {
        String masterURI = "not found";
        for (ClusterMember member : ((ClusterMembers)this.haDb.getDependencyResolver().resolveDependency(ClusterMembers.class)).getMembers()) {
            if (!"master".equals(member.getHARole())) continue;
            masterURI = member.getHAUri().getHost() + ":" + member.getHAUri().getPort();
        }
        return masterURI;
    }

    public String getName() {
        return "ha";
    }

    public String getServerPath() {
        return BASE_PATH;
    }
}

