/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.server.enterprise.EnterpriseDatabase;
import org.neo4j.server.preflight.EnsureNeo4jPropertiesExist;

public class EnsureEnterpriseNeo4jPropertiesExist
extends EnsureNeo4jPropertiesExist {
    public static final String CONFIG_KEY_OLD_SERVER_ID = "ha.machine_id";
    public static final String CONFIG_KEY_OLD_COORDINATORS = "ha.zoo_keeper_servers";

    public EnsureEnterpriseNeo4jPropertiesExist(Configuration config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateProperties(Properties configProperties) {
        String dbMode = configProperties.getProperty("org.neo4j.server.database.mode", EnterpriseDatabase.DatabaseMode.SINGLE.name());
        if ((dbMode = dbMode.toUpperCase()).equals(EnterpriseDatabase.DatabaseMode.SINGLE.name())) {
            return true;
        }
        if (!dbMode.equals(EnterpriseDatabase.DatabaseMode.HA.name())) {
            this.failureMessage = String.format("Illegal value for %s \"%s\" in %s", "org.neo4j.server.database.mode", dbMode, "org.neo4j.server.properties");
            return false;
        }
        String dbTuningFilename = configProperties.getProperty("org.neo4j.server.db.tuning.properties");
        if (dbTuningFilename == null) {
            this.failureMessage = String.format("High-Availability mode requires %s to be set in %s", "org.neo4j.server.db.tuning.properties", "org.neo4j.server.properties");
            return false;
        }
        File dbTuningFile = new File(dbTuningFilename);
        if (!dbTuningFile.exists()) {
            this.failureMessage = String.format("No database tuning file at [%s]", dbTuningFile.getAbsoluteFile());
            return false;
        }
        Properties dbTuning = new Properties();
        try {
            FileInputStream tuningStream = new FileInputStream(dbTuningFile);
            try {
                dbTuning.load(tuningStream);
            }
            finally {
                ((InputStream)tuningStream).close();
            }
        }
        catch (IOException e) {
            this.failureMessage = e.getMessage();
            return false;
        }
        String machineId = null;
        try {
            machineId = this.getSinglePropertyFromCandidates(dbTuning, ClusterSettings.server_id.name(), CONFIG_KEY_OLD_SERVER_ID, "<not set>");
            if (Integer.parseInt(machineId) < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.failureMessage = String.format("%s in %s needs to be a non-negative integer, not %s", ClusterSettings.server_id.name(), dbTuningFilename, machineId);
            return false;
        }
        catch (IllegalArgumentException e) {
            this.failureMessage = String.format("%s in %s", e.getMessage(), dbTuningFilename);
            return false;
        }
        return true;
    }

    private String getSinglePropertyFromCandidates(Properties dbTuning, String first, String other, String defaultValue) {
        String firstValue = dbTuning.getProperty(first);
        String otherValue = dbTuning.getProperty(other);
        if (firstValue == null && otherValue == null) {
            return defaultValue;
        }
        if (firstValue != null && otherValue != null) {
            throw new IllegalArgumentException("Multiple configuration values set for the same logical property [" + first + "," + other + "]");
        }
        return firstValue != null ? firstValue : otherValue;
    }
}

