/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.functional;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappingDatabase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.webadmin.console.ConsoleSessionFactory;
import org.neo4j.server.webadmin.console.ScriptSession;
import org.neo4j.server.webadmin.console.ShellSession;
import org.neo4j.server.webadmin.rest.console.ConsoleService;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.TargetDirectory;

@Ignore(value="Due to fix (62e73bfe8265971cebff166bb9ec8a6de3ab8f39) in community not working")
public class Neo4jShellConsoleSessionTest
implements ConsoleSessionFactory {
    private ConsoleService consoleService;
    private final URI uri = URI.create("http://peteriscool.com:6666/");
    private Database master;
    private Database slave;
    private ShellSession session;

    @Before
    public void setUp() throws Exception {
        TargetDirectory dir = TargetDirectory.forTest(this.getClass());
        this.master = new WrappingDatabase((AbstractGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(dir.directory("1", true).getAbsolutePath()).setConfig(ShellSettings.remote_shell_enabled, "true").setConfig(ShellSettings.remote_shell_port, "1337").setConfig(ClusterSettings.server_id, "1").setConfig(HaSettings.ha_server, "localhost:6361").newGraphDatabase());
        this.createData(this.master.getGraph());
        this.slave = new WrappingDatabase((AbstractGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(dir.directory("2", true).getAbsolutePath()).setConfig(ShellSettings.remote_shell_enabled, "true").setConfig(ShellSettings.remote_shell_port, "1338").setConfig(ClusterSettings.server_id, "2").setConfig(HaSettings.ha_server, "localhost:6362").newGraphDatabase());
        this.consoleService = new ConsoleService((ConsoleSessionFactory)this, this.slave, new OutputFormat((RepresentationFormat)new JsonFormat(), this.uri, null));
        this.session = new ShellSession(this.slave.getGraph());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createData(GraphDatabaseAPI db) {
        Transaction tx = db.beginTx();
        try {
            db.getReferenceNode().createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            db.getReferenceNode().setProperty("name", (Object)"Test");
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @After
    public void shutdownDatabase() {
        this.slave.getGraph().shutdown();
    }

    public ScriptSession createSession(String engineName, Database database) {
        return this.session;
    }

    public Iterable<String> supportedEngines() {
        return null;
    }

    @Test
    public void haMasterSwitchLeavesAWorkingShell() throws Exception {
        Assert.assertTrue((boolean)((HighlyAvailableGraphDatabase)this.master.getGraph()).isMaster());
        this.issueAndAssertResponse();
        this.master.getGraph().shutdown();
        try {
            ((UpdatePuller)this.slave.getGraph().getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertTrue((boolean)((HighlyAvailableGraphDatabase)this.slave.getGraph()).isMaster());
        this.issueAndAssertResponse();
    }

    private void issueAndAssertResponse() throws Exception {
        Response response = this.consoleService.exec((InputFormat)new JsonFormat(), "{ \"command\" : \"ls\", \"engine\":\"shell\" }");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String result = this.decode(response).get(0);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"Test"));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"me"));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"-[:TEST]->"));
    }

    private List<String> decode(Response response) throws UnsupportedEncodingException, JsonParseException {
        return (List)JsonHelper.readJson((String)new String((byte[])response.getEntity(), "UTF-8"));
    }
}

