/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.server.database.CommunityDatabase;
import org.neo4j.server.database.GraphDatabaseFactory;

public class EnterpriseDatabase
extends CommunityDatabase {
    public EnterpriseDatabase(Configuration serverConfig) {
        super(serverConfig);
    }

    public void start() throws Throwable {
        try {
            DatabaseMode factory = DatabaseMode.valueOf(this.serverConfig.getString("org.neo4j.server.database.mode", DatabaseMode.SINGLE.name()).toUpperCase());
            this.graph = (AbstractGraphDatabase)factory.createDatabase(this.serverConfig.getString("org.neo4j.server.database.location", "data/graph.db"), this.loadNeo4jProperties());
            log.info("Successfully started database", new Object[0]);
        }
        catch (Exception e) {
            log.error("Failed to start database.", new Object[]{e});
            throw e;
        }
    }

    static enum DatabaseMode implements GraphDatabaseFactory
    {
        SINGLE{

            @Override
            public GraphDatabaseAPI createDatabase(String databaseStoreDirectory, Map<String, String> databaseProperties) {
                return new EmbeddedGraphDatabase(databaseStoreDirectory, databaseProperties);
            }
        }
        ,
        HA{

            @Override
            public GraphDatabaseAPI createDatabase(String databaseStoreDirectory, Map<String, String> databaseProperties) {
                List indexProviders = Iterables.toList((Iterable)Service.load(IndexProvider.class));
                List kernelExtensions = Iterables.toList((Iterable)Iterables.cast((Iterable)Service.load(KernelExtensionFactory.class)));
                List cacheProviders = Iterables.toList((Iterable)Service.load(CacheProvider.class));
                List txInterceptorProviders = Iterables.toList((Iterable)Service.load(TransactionInterceptorProvider.class));
                List schemaIndexProviders = Iterables.toList((Iterable)Service.load(SchemaIndexProvider.class));
                return new HighlyAvailableGraphDatabase(databaseStoreDirectory, databaseProperties, (Iterable)indexProviders, (Iterable)kernelExtensions, (Iterable)cacheProviders, (Iterable)txInterceptorProviders);
            }
        };


        public abstract GraphDatabaseAPI createDatabase(String var1, Map<String, String> var2);
    }
}

