/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import ch.qos.logback.classic.LoggerContext;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.ChannelException;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.logging.ClassicLoggingService;
import org.neo4j.kernel.logging.LogbackService;
import org.neo4j.kernel.logging.Logging;
import org.slf4j.impl.StaticLoggerBinder;

public class StandaloneClusterClient {
    private final LifeSupport life = new LifeSupport();

    private StandaloneClusterClient(ClusterClient clusterClient) {
        this.life.add((Object)clusterClient);
        this.addShutdownHook();
        this.life.start();
    }

    protected void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (StandaloneClusterClient.this.life != null) {
                    StandaloneClusterClient.this.life.shutdown();
                }
            }
        });
    }

    public static void main(String[] args) {
        String propertiesFile = System.getProperty("org.neo4j.server.properties");
        File dbProperties = StandaloneClusterClient.extractDbTuningProperties(propertiesFile);
        Map<String, String> config = MapUtil.stringMap((String[])new String[0]);
        if (dbProperties != null) {
            if (!dbProperties.exists()) {
                throw new IllegalArgumentException(dbProperties + " doesn't exist");
            }
            config = StandaloneClusterClient.readFromConfigConfig(config, dbProperties);
        }
        config.putAll(new Args(args).asMap());
        StandaloneClusterClient.verifyConfig(config);
        try {
            new StandaloneClusterClient(new ClusterClient(ClusterClient.adapt((Config)new Config(config)), StandaloneClusterClient.logging(), (ElectionCredentialsProvider)new NotElectableElectionCredentialsProvider()));
        }
        catch (LifecycleException e) {
            Throwable cause = Exceptions.peel((Throwable)e, (Predicate)Exceptions.exceptionsOfType((Class[])new Class[]{LifecycleException.class}));
            if (cause instanceof ChannelException) {
                System.err.println("ERROR: " + cause.getMessage() + (cause.getCause() != null ? ", caused by:" + cause.getCause().getMessage() : ""));
            }
            System.err.println("ERROR: Unknown error");
            throw e;
        }
    }

    private static void verifyConfig(Map<String, String> config) {
        if (!config.containsKey(ClusterSettings.initial_hosts.name())) {
            System.err.println("No initial hosts to connect to supplied");
            System.exit(1);
        }
    }

    private static Map<String, String> readFromConfigConfig(Map<String, String> config, File propertiesFile) {
        HashMap<String, String> result = new HashMap<String, String>(config);
        Map existingConfig = MapUtil.loadStrictly((File)propertiesFile);
        for (Setting setting : new Setting[]{ClusterSettings.initial_hosts, ClusterSettings.cluster_name, ClusterSettings.cluster_server}) {
            StandaloneClusterClient.moveOver(existingConfig, result, setting);
        }
        return result;
    }

    private static void moveOver(Map<String, String> from, Map<String, String> to, Setting setting) {
        String key = setting.name();
        if (from.containsKey(key)) {
            to.put(key, from.get(key));
        }
    }

    private static Logging logging() {
        ClassicLoggingService logging;
        File home = new File(System.getProperty("neo4j.home"));
        String logDir = System.getProperty("org.neo4j.cluster.logdirectory", new File(new File(home, "data"), "log").getPath());
        Config config = new Config(MapUtil.stringMap((String[])new String[]{InternalAbstractGraphDatabase.Configuration.store_dir.name(), logDir}));
        try {
            StandaloneClusterClient.class.getClassLoader().loadClass("ch.qos.logback.classic.LoggerContext");
            LogbackService logback = new LogbackService(config, (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory());
            logging = logback;
        }
        catch (ClassNotFoundException e) {
            logging = new ClassicLoggingService(config);
        }
        return logging;
    }

    private static File extractDbTuningProperties(String propertiesFile) {
        if (propertiesFile == null) {
            return null;
        }
        File serverConfigFile = new File(propertiesFile);
        if (!serverConfigFile.exists()) {
            return null;
        }
        Map serverConfig = MapUtil.loadStrictly((File)serverConfigFile);
        String dbTuningFile = (String)serverConfig.get("org.neo4j.server.db.tuning.properties");
        if (dbTuningFile == null) {
            return null;
        }
        File result = new File(dbTuningFile);
        return result.exists() ? result : null;
    }
}

