/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.JAXRSHelper;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;
import org.neo4j.server.webadmin.rest.MasterInfoService;

public class MasterInfoServerModule
implements ServerModule {
    private static final Logger log = Logger.getLogger(MasterInfoServerModule.class);
    private final WebServer server;
    private final Configuration config;

    public MasterInfoServerModule(WebServer server, Configuration config) {
        this.server = server;
        this.config = config;
    }

    public void start(StringLogger logger) {
        try {
            URI baseUri = this.managementApiUri();
            this.server.addJAXRSClasses(this.getClassNames(), baseUri.toString(), null);
            log.info("Mounted REST API at: " + baseUri.toString(), new Object[0]);
            if (logger != null) {
                logger.logMessage("Mounted REST API at: " + baseUri.toString());
            }
        }
        catch (UnknownHostException e) {
            log.warn((Throwable)e);
        }
    }

    public void stop() {
        try {
            URI baseUri = this.managementApiUri();
            this.server.removeJAXRSClasses(this.getClassNames(), baseUri.toString());
        }
        catch (UnknownHostException e) {
            log.warn((Throwable)e);
        }
    }

    private List<String> getClassNames() {
        return JAXRSHelper.listFrom((String[])new String[]{MasterInfoService.class.getName()});
    }

    private URI managementApiUri() throws UnknownHostException {
        return URI.create(this.config.getString("org.neo4j.server.webadmin.management.uri", "/db/manage"));
    }
}

