/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.helpers;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.EphemeralDatabase;
import org.neo4j.server.enterprise.EnterpriseNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.LoggingFactory;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.rest.web.DatabaseActions;

public class EnterpriseServerBuilder
extends CommunityServerBuilder {
    protected EnterpriseServerBuilder(LoggingFactory loggingFactory) {
        super(loggingFactory);
    }

    public static EnterpriseServerBuilder server() {
        return EnterpriseServerBuilder.server(LoggingFactory.IMPERMANENT_LOGGING);
    }

    public static EnterpriseServerBuilder server(LoggingFactory loggingFactory) {
        return new EnterpriseServerBuilder(loggingFactory);
    }

    public EnterpriseNeoServer build() throws IOException {
        return (EnterpriseNeoServer)super.build();
    }

    public EnterpriseNeoServer build(File configFile, Configurator configurator, Logging logging) {
        return new TestEnterpriseNeoServer(configurator, configFile, logging);
    }

    private class TestEnterpriseNeoServer
    extends EnterpriseNeoServer {
        private final File configFile;

        public TestEnterpriseNeoServer(Configurator propertyFileConfigurator, File configFile, Logging logging) {
            super(propertyFileConfigurator, logging);
            this.configFile = configFile;
        }

        protected PreFlightTasks createPreflightTasks() {
            return EnterpriseServerBuilder.this.preflightTasks;
        }

        protected Database createDatabase() {
            return EnterpriseServerBuilder.this.persistent ? super.createDatabase() : new EphemeralDatabase(this.configurator);
        }

        protected DatabaseActions createDatabaseActions() {
            return EnterpriseServerBuilder.this.createDatabaseActionsObject(this.database, this.configurator);
        }

        public void stop() {
            super.stop();
            this.configFile.delete();
        }
    }
}

