/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.helpers;

import java.io.File;
import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.validation.DatabaseLocationMustBeSpecifiedRule;
import org.neo4j.server.configuration.validation.ValidationRule;
import org.neo4j.server.configuration.validation.Validator;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.enterprise.EnterpriseNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightTask;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.web.DatabaseActions;

public class EnterpriseServerBuilder
extends CommunityServerBuilder {
    public static EnterpriseServerBuilder server() {
        return new EnterpriseServerBuilder();
    }

    public EnterpriseNeoServer build() throws IOException {
        if (this.dbDir == null) {
            this.dbDir = ServerTestUtils.createTempDir().getAbsolutePath();
        }
        File configFile = this.createPropertiesFiles();
        if (this.preflightTasks == null) {
            this.preflightTasks = new PreFlightTasks(new PreflightTask[0]){

                public boolean run() {
                    return true;
                }
            };
        }
        return new TestEnterpriseNeoServer(new PropertyFileConfigurator(new Validator(new ValidationRule[]{new DatabaseLocationMustBeSpecifiedRule()}), configFile), configFile);
    }

    private class TestEnterpriseNeoServer
    extends EnterpriseNeoServer {
        private final File configFile;

        public TestEnterpriseNeoServer(PropertyFileConfigurator propertyFileConfigurator, File configFile) {
            super((Configurator)propertyFileConfigurator, EnterpriseServerBuilder.this.persistent ? TestEnterpriseNeoServer.createDbFactory((Configuration)propertyFileConfigurator.configuration()) : LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)CommunityServerBuilder.IN_MEMORY_DB));
            this.configFile = configFile;
        }

        protected PreFlightTasks createPreflightTasks() {
            return EnterpriseServerBuilder.this.preflightTasks;
        }

        protected DatabaseActions createDatabaseActions() {
            Clock clockToUse = EnterpriseServerBuilder.this.clock != null ? EnterpriseServerBuilder.this.clock : Clock.SYSTEM_CLOCK;
            return new DatabaseActions(new LeaseManager(clockToUse), ForceMode.forced, this.configurator.configuration().getBoolean("org.neo4j.server.script.sandboxing.enabled", Configurator.DEFAULT_SCRIPT_SANDBOXING_ENABLED).booleanValue(), this.database.getGraph());
        }

        public void stop() {
            super.stop();
            this.configFile.delete();
        }
    }
}

