/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.validation.Validator;
import org.neo4j.server.enterprise.EnsureEnterpriseNeo4jPropertiesExist;
import org.neo4j.server.enterprise.ServerTestUtils;

public class Neo4jHAPropertiesMustExistRuleTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    public static final String CONFIG_KEY_OLD_SERVER_ID = "ha.machine_id";
    public static final String CONFIG_KEY_OLD_COORDINATORS = "ha.zoo_keeper_servers";

    @Test
    public void shouldPassIfHaModeNotSpecified() throws Exception {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile("touch", "me", serverPropertyFile);
        this.assertRulePass(serverPropertyFile);
    }

    @Test
    public void shouldFailIfInvalidModeSpecified() throws Exception {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "faulty", serverPropertyFile);
        this.assertRuleFail(serverPropertyFile);
    }

    @Test
    public void shouldPassIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedAndExists() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        File dbTuningFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        ServerTestUtils.writePropertyToFile(ClusterSettings.server_id.name(), "1", dbTuningFile);
        this.assertRulePass(serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldPassIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedAndExistsWithOldConfig() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        File dbTuningFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        ServerTestUtils.writePropertyToFile(CONFIG_KEY_OLD_SERVER_ID, "1", dbTuningFile);
        ServerTestUtils.writePropertyToFile(CONFIG_KEY_OLD_COORDINATORS, "localhost:0000", dbTuningFile);
        this.assertRulePass(serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldFailIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedAndExistsWithDuplicateIdConfig() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        File dbTuningFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        ServerTestUtils.writePropertyToFile(CONFIG_KEY_OLD_SERVER_ID, "1", dbTuningFile);
        ServerTestUtils.writePropertyToFile(ClusterSettings.server_id.name(), "1", dbTuningFile);
        this.assertRuleFail(serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldFailIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedButDoesNotExist() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        File dbTuningFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile("org.neo4j.server.db.tuning.properties", dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        this.assertRuleFail(serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldFailIfHAModeIsSetAndTheDbTuningFileHasNotBeenSpecified() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile("org.neo4j.server.database.mode", "ha", serverPropertyFile);
        this.assertRuleFail(serverPropertyFile);
        serverPropertyFile.delete();
    }

    private void assertRulePass(File file) {
        EnsureEnterpriseNeo4jPropertiesExist rule = new EnsureEnterpriseNeo4jPropertiesExist(this.propertiesWithConfigFileLocation(file));
        if (!rule.run()) {
            Assert.fail((String)rule.getFailureMessage());
        }
    }

    private void assertRuleFail(File file) {
        EnsureEnterpriseNeo4jPropertiesExist rule = new EnsureEnterpriseNeo4jPropertiesExist(this.propertiesWithConfigFileLocation(file));
        if (rule.run()) {
            Assert.fail((String)(rule + " should have failed"));
        }
    }

    private Configuration propertiesWithConfigFileLocation(File propertyFile) {
        PropertyFileConfigurator config = new PropertyFileConfigurator(Validator.NO_VALIDATION, propertyFile, ConsoleLogger.DEV_NULL);
        config.configuration().setProperty("org.neo4j.server.properties", (Object)propertyFile.getAbsolutePath());
        return config.configuration();
    }
}

