/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server.ha;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.server.enterprise.EnterpriseNeoServer;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;
import org.neo4j.server.helpers.Transactor;
import org.neo4j.server.helpers.UnitOfWork;
import org.neo4j.tooling.GlobalGraphOperations;

public class EnterpriseServerHelper {
    public static void cleanTheDatabase(final EnterpriseNeoServer server) {
        if (server == null) {
            return;
        }
        new Transactor((GraphDatabaseService)server.getDatabase().getGraph(), new UnitOfWork(){

            public void doWork() {
                this.deleteAllNodesAndRelationships(server);
                this.deleteAllIndexes(server);
            }

            private void deleteAllNodesAndRelationships(EnterpriseNeoServer server2) {
                ResourceIterable allNodes = GlobalGraphOperations.at((GraphDatabaseService)server2.getDatabase().getGraph()).getAllNodes();
                for (Node n : allNodes) {
                    Iterable relationships = n.getRelationships();
                    for (Relationship rel : relationships) {
                        rel.delete();
                    }
                    if (n.getId() != 0L) {
                        n.delete();
                        continue;
                    }
                    for (String key : n.getPropertyKeys()) {
                        n.removeProperty(key);
                    }
                }
            }

            private void deleteAllIndexes(EnterpriseNeoServer server2) {
                IndexManager indexManager = server2.getDatabase().getGraph().index();
                for (String indexName : indexManager.nodeIndexNames()) {
                    try {
                        server2.getDatabase().getGraph().index().forNodes(indexName).delete();
                    }
                    catch (UnsupportedOperationException e) {
                        // empty catch block
                    }
                }
                for (String indexName : indexManager.relationshipIndexNames()) {
                    try {
                        server2.getDatabase().getGraph().index().forRelationships(indexName).delete();
                    }
                    catch (UnsupportedOperationException e) {
                        // empty catch block
                    }
                }
                for (String k : indexManager.getNodeAutoIndexer().getAutoIndexedProperties()) {
                    indexManager.getNodeAutoIndexer().stopAutoIndexingProperty(k);
                }
                indexManager.getNodeAutoIndexer().setEnabled(false);
                for (String k : indexManager.getRelationshipAutoIndexer().getAutoIndexedProperties()) {
                    indexManager.getRelationshipAutoIndexer().stopAutoIndexingProperty(k);
                }
                indexManager.getRelationshipAutoIndexer().setEnabled(false);
            }
        }).execute();
        EnterpriseServerHelper.removeLogs(server);
    }

    private static void removeLogs(EnterpriseNeoServer server) {
        File logDir = new File(server.getDatabase().getLocation() + File.separator + ".." + File.separator + "log");
        try {
            FileUtils.deleteDirectory((File)logDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static EnterpriseNeoServer createNonPersistentServer(File databaseDir) throws IOException {
        return EnterpriseServerHelper.createServer(databaseDir, false);
    }

    private static EnterpriseNeoServer createServer(File databaseDir, boolean persistent) throws IOException {
        EnterpriseServerBuilder builder = EnterpriseServerBuilder.server().usingDatabaseDir(databaseDir.getAbsolutePath());
        EnterpriseServerHelper.configureHostname(builder);
        if (persistent) {
            builder = (EnterpriseServerBuilder)builder.persistent();
        }
        EnterpriseNeoServer server = builder.build();
        server.start();
        return server;
    }

    private static void configureHostname(EnterpriseServerBuilder builder) {
        String hostName = System.getProperty("neo-server.test.hostname");
        if (StringUtils.isNotEmpty((String)hostName)) {
            builder.onHost(hostName);
        }
    }
}

