/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Random;

public class ServerTestUtils {
    public static void writePropertyToFile(String name, String value, File propertyFile) {
        Properties properties = ServerTestUtils.loadProperties(propertyFile);
        properties.setProperty(name, value);
        ServerTestUtils.storeProperties(propertyFile, properties);
    }

    private static void storeProperties(File propertyFile, Properties properties) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(propertyFile);
            properties.store(out, "");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ServerTestUtils.safeClose(out);
                throw throwable;
            }
        }
        ServerTestUtils.safeClose(out);
    }

    private static Properties loadProperties(File propertyFile) {
        Properties properties = new Properties();
        if (propertyFile.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(propertyFile);
                properties.load(in);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    ServerTestUtils.safeClose(in);
                    throw throwable;
                }
            }
            ServerTestUtils.safeClose(in);
        }
        return properties;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File createTempPropertyFile(File parentDir) throws IOException {
        return new File(parentDir, "test-" + new Random().nextInt() + ".properties");
    }
}

