/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.configuration.ConfigurationBuilder;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.enterprise.EnterpriseNeoServer;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.test.TargetDirectory;

public class StartupTimeoutFunctionalTest {
    @Rule
    public TargetDirectory.TestDirectory target = TargetDirectory.testDirForTest(this.getClass());
    public EnterpriseNeoServer server;

    @After
    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    @Test
    public void shouldTimeoutIfStartupTakesLongerThanTimeout() throws IOException {
        ConfigurationBuilder configurator = this.buildProperties();
        this.setProperty(configurator.configuration(), Configurator.STARTUP_TIMEOUT, "1s");
        this.server = this.createSlowServer(configurator);
        try {
            this.server.start();
            Assert.fail((String)"Should have been interrupted.");
        }
        catch (ServerStartupException serverStartupException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotFailIfStartupTakesLessTimeThanTimeout() throws IOException {
        ConfigurationBuilder configurator = this.buildProperties();
        this.setProperty(configurator.configuration(), Configurator.STARTUP_TIMEOUT, "20s");
        this.server = new EnterpriseNeoServer(configurator, (InternalAbstractGraphDatabase.Dependencies)GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)NullLogProvider.getInstance()), (LogProvider)NullLogProvider.getInstance()){

            protected Iterable<ServerModule> createServerModules() {
                return Arrays.asList(new Object[0]);
            }
        };
        this.server.start();
    }

    @Test
    public void shouldNotTimeOutIfTimeoutDisabled() throws IOException {
        ConfigurationBuilder configurator = this.buildProperties();
        this.setProperty(configurator.configuration(), Configurator.STARTUP_TIMEOUT, "0");
        this.server = this.createSlowServer(configurator);
        this.server.start();
    }

    private EnterpriseNeoServer createSlowServer(ConfigurationBuilder configurator) {
        return new EnterpriseNeoServer(configurator, (InternalAbstractGraphDatabase.Dependencies)GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)NullLogProvider.getInstance()), (LogProvider)NullLogProvider.getInstance()){

            protected Iterable<ServerModule> createServerModules() {
                ServerModule slowModule = new ServerModule(){

                    public void start() {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public void stop() {
                    }
                };
                return Arrays.asList(slowModule);
            }
        };
    }

    private ConfigurationBuilder buildProperties() throws IOException {
        new File(this.target.directory(), "conf").mkdir();
        Properties databaseProperties = new Properties();
        String databasePropertiesFileName = new File(this.target.directory(), "conf/neo4j.properties").getAbsolutePath();
        databaseProperties.setProperty(ClusterSettings.server_id.name(), "1");
        databaseProperties.setProperty(ClusterSettings.initial_hosts.name(), ":5001,:5002,:5003");
        databaseProperties.store(new FileWriter(databasePropertiesFileName), null);
        Properties serverProperties = new Properties();
        String serverPropertiesFilename = new File(this.target.directory(), "conf/neo4j-server.properties").getAbsolutePath();
        serverProperties.setProperty(Configurator.DATABASE_LOCATION_PROPERTY_KEY, new File(this.target.directory(), "data/graph.db").getAbsolutePath());
        serverProperties.setProperty(Configurator.DB_TUNING_PROPERTY_FILE_KEY, databasePropertiesFileName);
        serverProperties.setProperty("org.neo4j.server.properties", serverPropertiesFilename);
        serverProperties.store(new FileWriter(serverPropertiesFilename), null);
        return new PropertyFileConfigurator(new File(serverPropertiesFilename), (Log)FormattedLog.toOutputStream((OutputStream)System.err));
    }

    private void setProperty(Config config, String key, String value) {
        Map params = config.getParams();
        params.put(key, value);
        config.applyChanges(params);
    }
}

