/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.enterprise.EnsureEnterpriseNeo4jPropertiesExist;
import org.neo4j.server.enterprise.ServerTestUtils;

public class Neo4jHAPropertiesMustExistRuleTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private static final String CONFIG_KEY_OLD_SERVER_ID = "ha.machine_id";

    @Test
    public void shouldPassIfHaModeNotSpecified() throws Exception {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile("touch", "me", serverPropertyFile);
        this.assertRulePass(serverPropertyFile);
    }

    @Test
    public void shouldFailIfInvalidModeSpecified() throws Exception {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile(Configurator.DB_MODE_KEY, "faulty", serverPropertyFile);
        this.assertRuleFail(serverPropertyFile);
    }

    @Test
    public void shouldPassIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedAndExists() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        File dbTuningFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile(Configurator.DB_TUNING_PROPERTY_FILE_KEY, dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile(Configurator.DB_MODE_KEY, "ha", serverPropertyFile);
        ServerTestUtils.writePropertyToFile(ClusterSettings.server_id.name(), "1", dbTuningFile);
        this.assertRulePass(serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldPassIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedAndExistsWithOldConfig() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        File dbTuningFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile(Configurator.DB_TUNING_PROPERTY_FILE_KEY, dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile(Configurator.DB_MODE_KEY, "ha", serverPropertyFile);
        ServerTestUtils.writePropertyToFile(CONFIG_KEY_OLD_SERVER_ID, "1", dbTuningFile);
        this.assertRulePass(serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldFailIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedAndExistsWithDuplicateIdConfig() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        File dbTuningFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile(Configurator.DB_TUNING_PROPERTY_FILE_KEY, dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile(Configurator.DB_MODE_KEY, "ha", serverPropertyFile);
        ServerTestUtils.writePropertyToFile(CONFIG_KEY_OLD_SERVER_ID, "1", dbTuningFile);
        ServerTestUtils.writePropertyToFile(ClusterSettings.server_id.name(), "1", dbTuningFile);
        this.assertRuleFail(serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldFailIfHAModeIsSetAndTheDbTuningFileHasBeenSpecifiedButDoesNotExist() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        File dbTuningFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile(Configurator.DB_TUNING_PROPERTY_FILE_KEY, dbTuningFile.getAbsolutePath(), serverPropertyFile);
        ServerTestUtils.writePropertyToFile(Configurator.DB_MODE_KEY, "ha", serverPropertyFile);
        this.assertRuleFail(serverPropertyFile);
        serverPropertyFile.delete();
        dbTuningFile.delete();
    }

    @Test
    public void shouldFailIfHAModeIsSetAndTheDbTuningFileHasNotBeenSpecified() throws IOException {
        File serverPropertyFile = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        ServerTestUtils.writePropertyToFile(Configurator.DB_MODE_KEY, "ha", serverPropertyFile);
        this.assertRuleFail(serverPropertyFile);
        serverPropertyFile.delete();
    }

    private void assertRulePass(File file) {
        EnsureEnterpriseNeo4jPropertiesExist rule = new EnsureEnterpriseNeo4jPropertiesExist(this.propertiesWithConfigFileLocation(file));
        if (!rule.run()) {
            Assert.fail((String)rule.getFailureMessage());
        }
    }

    private void assertRuleFail(File file) {
        EnsureEnterpriseNeo4jPropertiesExist rule = new EnsureEnterpriseNeo4jPropertiesExist(this.propertiesWithConfigFileLocation(file));
        if (rule.run()) {
            Assert.fail((String)(rule + " should have failed"));
        }
    }

    private Config propertiesWithConfigFileLocation(File propertyFile) {
        PropertyFileConfigurator config = new PropertyFileConfigurator(propertyFile, (Log)NullLog.getInstance());
        Map params = config.configuration().getParams();
        params.put("org.neo4j.server.properties", propertyFile.getAbsolutePath());
        config.configuration().applyChanges(params);
        return config.configuration();
    }
}

