/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.helpers;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ConfigurationBuilder;
import org.neo4j.server.enterprise.EnterpriseNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.rest.web.DatabaseActions;

public class EnterpriseServerBuilder
extends CommunityServerBuilder {
    protected EnterpriseServerBuilder(LogProvider logProvider) {
        super(logProvider);
    }

    public static EnterpriseServerBuilder server() {
        return EnterpriseServerBuilder.server((LogProvider)NullLogProvider.getInstance());
    }

    public static EnterpriseServerBuilder server(LogProvider logProvider) {
        return new EnterpriseServerBuilder(logProvider);
    }

    public EnterpriseNeoServer build() throws IOException {
        return (EnterpriseNeoServer)super.build();
    }

    public EnterpriseServerBuilder usingDatabaseDir(String dbDir) {
        super.usingDatabaseDir(dbDir);
        return this;
    }

    protected CommunityNeoServer build(File configFile, ConfigurationBuilder configurator, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        return new TestEnterpriseNeoServer(configurator, configFile, dependencies, this.logProvider);
    }

    private class TestEnterpriseNeoServer
    extends EnterpriseNeoServer {
        private final File configFile;

        public TestEnterpriseNeoServer(ConfigurationBuilder propertyFileConfigurator, File configFile, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
            super(propertyFileConfigurator, dependencies, logProvider);
            this.configFile = configFile;
        }

        protected PreFlightTasks createPreflightTasks() {
            return EnterpriseServerBuilder.this.preflightTasks;
        }

        protected DatabaseActions createDatabaseActions() {
            return EnterpriseServerBuilder.this.createDatabaseActionsObject(this.database, this.configurator);
        }

        public void stop() {
            super.stop();
            this.configFile.delete();
        }
    }
}

