/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.SystemUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.client.ClusterClientModule;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.ServerIdElectionCredentialsProvider;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.enterprise.StandaloneClusterClientTestProxy;
import org.neo4j.server.enterprise.functional.DumpPortListenerOnNettyBindFailure;
import org.neo4j.test.InputStreamAwaiter;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.StreamConsumer;
import org.neo4j.test.TargetDirectory;

public class StandaloneClusterClientIT {
    private static Integer SHOULD_NOT_JOIN = null;
    @Rule
    public TestRule dumpPorts = new DumpPortListenerOnNettyBindFailure();
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    private File directory;
    private LifeSupport life;
    private ClusterClient[] clients;

    @Test
    public void canJoinWithExplicitInitialHosts() throws Exception {
        this.startAndAssertJoined(5003, MapUtil.stringMap((String[])new String[0]), MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5001", ClusterSettings.server_id.name(), "3"}));
    }

    @Test
    public void willFailJoinIfIncorrectInitialHostsSet() throws Exception {
        Assume.assumeFalse((String)"Cannot kill processes on windows.", (boolean)SystemUtils.IS_OS_WINDOWS);
        this.startAndAssertJoined(SHOULD_NOT_JOIN, MapUtil.stringMap((String[])new String[0]), MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5011", ClusterSettings.server_id.name(), "3"}));
    }

    @Test
    public void canJoinWithInitialHostsInConfigFile() throws Exception {
        this.startAndAssertJoined(5003, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5001"}), MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "3"}));
    }

    @Test
    public void willFailJoinIfIncorrectInitialHostsSetInConfigFile() throws Exception {
        Assume.assumeFalse((String)"Cannot kill processes on windows.", (boolean)SystemUtils.IS_OS_WINDOWS);
        this.startAndAssertJoined(SHOULD_NOT_JOIN, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5011"}), MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "3"}));
    }

    @Test
    public void canOverrideInitialHostsConfigFromConfigFile() throws Exception {
        this.startAndAssertJoined(5003, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5011"}), MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5001", ClusterSettings.server_id.name(), "3"}));
    }

    @Test
    public void canSetSpecificPort() throws Exception {
        this.startAndAssertJoined(5010, MapUtil.stringMap((String[])new String[0]), MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5001", ClusterSettings.server_id.name(), "3", ClusterSettings.cluster_server.name(), ":5010"}));
    }

    @Test
    public void usesPortRangeFromConfigFile() throws Exception {
        this.startAndAssertJoined(5012, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), ":5001", ClusterSettings.cluster_server.name(), ":5012-5020"}), MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "3"}));
    }

    @Before
    public void before() throws Exception {
        this.directory = this.testDirectory.directory("temp");
        this.life = new LifeSupport();
        this.life.start();
        this.clients = new ClusterClient[2];
        for (int i = 1; i <= this.clients.length; ++i) {
            Map config = MapUtil.stringMap((String[])new String[0]);
            config.put(ClusterSettings.cluster_server.name(), ":" + (5000 + i));
            config.put(ClusterSettings.server_id.name(), "" + i);
            config.put(ClusterSettings.initial_hosts.name(), ":5001");
            ClusterClientModule clusterClientModule = new ClusterClientModule(null, new Dependencies(), new Monitors(), new Config(config), (LogService)NullLogService.getInstance(), (ElectionCredentialsProvider)new ServerIdElectionCredentialsProvider());
            final ClusterClient client = clusterClientModule.clusterClient;
            final CountDownLatch latch = new CountDownLatch(1);
            client.addClusterListener((ClusterListener)new ClusterListener.Adapter(){

                public void enteredCluster(ClusterConfiguration configuration) {
                    latch.countDown();
                    client.removeClusterListener((ClusterListener)this);
                }
            });
            this.life.add((Lifecycle)clusterClientModule.life);
            this.clients[i - 1] = client;
            Assert.assertTrue((String)"Didn't join the cluster", (boolean)latch.await(20L, TimeUnit.SECONDS));
        }
    }

    @After
    public void after() throws Exception {
        this.life.shutdown();
    }

    private File configFile(Map<String, String> config) throws IOException {
        File dbConfigFile = new File(this.directory, "config-file");
        MapUtil.store(config, (File)dbConfigFile);
        File serverConfigFile = new File(this.directory, "server-file");
        MapUtil.store((Map)MapUtil.stringMap((String[])new String[]{Configurator.DB_TUNING_PROPERTY_FILE_KEY, dbConfigFile.getAbsolutePath()}), (File)serverConfigFile);
        return serverConfigFile;
    }

    private void startAndAssertJoined(Integer expectedAssignedPort, Map<String, String> configInConfigFile, Map<String, String> config) throws Exception {
        File configFile = this.configFile(configInConfigFile);
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger port = new AtomicInteger();
        this.clients[0].addClusterListener((ClusterListener)this.joinAwaitingListener(latch, port));
        boolean clientStarted = this.startStandaloneClusterClient(configFile, config, latch);
        if (expectedAssignedPort == null) {
            Assert.assertFalse((String)String.format("Should not be able to start cluster client given config file:%s and arguments:%s", configInConfigFile, config), (boolean)clientStarted);
        } else {
            Assert.assertTrue((String)String.format("Should be able to start client client given config file:%s and arguments:%s", configInConfigFile, config), (boolean)clientStarted);
            Assert.assertEquals((long)expectedAssignedPort.intValue(), (long)port.get());
        }
    }

    private ClusterListener.Adapter joinAwaitingListener(final CountDownLatch latch, final AtomicInteger port) {
        return new ClusterListener.Adapter(){

            public void joinedCluster(InstanceId member, URI memberUri) {
                port.set(memberUri.getPort());
                latch.countDown();
                StandaloneClusterClientIT.this.clients[0].removeClusterListener((ClusterListener)this);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startStandaloneClusterClient(File configFile, Map<String, String> config, CountDownLatch latch) throws Exception {
        Process process = null;
        ProcessStreamHandler handler = null;
        try {
            process = this.startStandaloneClusterClientProcess(configFile, config);
            new InputStreamAwaiter(process.getInputStream()).awaitLine("starting", 20L, TimeUnit.SECONDS);
            handler = new ProcessStreamHandler(process, false, "", StreamConsumer.IGNORE_FAILURES);
            handler.launch();
            boolean bl = latch.await(10L, TimeUnit.SECONDS);
            return bl;
        }
        finally {
            if (process != null) {
                StandaloneClusterClientIT.kill(process);
                process.waitFor();
            }
            if (handler != null) {
                handler.done();
            }
        }
    }

    private Process startStandaloneClusterClientProcess(File configFile, Map<String, String> config) throws Exception {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("java", "-cp", System.getProperty("java.class.path"), "-Dneo4j.home=" + this.directory.getAbsolutePath()));
        if (configFile != null) {
            args.add("-Dorg.neo4j.server.properties=" + configFile.getAbsolutePath());
        }
        args.add(StandaloneClusterClientTestProxy.class.getName());
        for (Map.Entry<String, String> entry : config.entrySet()) {
            args.add("-" + entry.getKey() + "=" + entry.getValue());
        }
        return Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
    }

    private static void kill(Process process) throws NoSuchFieldException, IllegalAccessException, IOException, InterruptedException {
        if (SystemUtils.IS_OS_WINDOWS) {
            process.destroy();
        } else {
            int pid = ((Number)StandaloneClusterClientIT.accessible(process.getClass().getDeclaredField("pid")).get(process)).intValue();
            new ProcessBuilder("kill", "-9", "" + pid).start().waitFor();
        }
    }

    private static <T extends AccessibleObject> T accessible(T obj) {
        obj.setAccessible(true);
        return obj;
    }
}

