/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.neo4j.graphdb.EnterpriseGraphDatabase;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.advanced.AdvancedNeoServer;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.enterprise.EnterpriseServerSettings;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.web.ServerInternalSettings;
import org.neo4j.server.webadmin.rest.MasterInfoServerModule;
import org.neo4j.server.webadmin.rest.MasterInfoService;

public class EnterpriseNeoServer
extends AdvancedNeoServer {
    public static final String HA = "HA";
    private static final LifecycleManagingDatabase.GraphFactory HA_FACTORY = new LifecycleManagingDatabase.GraphFactory(){

        public GraphDatabaseAPI newGraphDatabase(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            File storeDir = (File)config.get(ServerInternalSettings.legacy_db_location);
            return new HighlyAvailableGraphDatabase(storeDir, config.getParams(), dependencies);
        }
    };
    private static final LifecycleManagingDatabase.GraphFactory ENTERPRISE_FACTORY = new LifecycleManagingDatabase.GraphFactory(){

        public GraphDatabaseAPI newGraphDatabase(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            File storeDir = (File)config.get(ServerInternalSettings.legacy_db_location);
            return new EnterpriseGraphDatabase(storeDir, config.getParams(), dependencies);
        }
    };

    public EnterpriseNeoServer(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
        super(config, EnterpriseNeoServer.createDbFactory(config), dependencies, logProvider);
    }

    protected static Database.Factory createDbFactory(Config config) {
        String mode = ((String)config.get(EnterpriseServerSettings.mode)).toUpperCase();
        return LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)(mode.equals(HA) ? HA_FACTORY : ENTERPRISE_FACTORY));
    }

    protected Iterable<ServerModule> createServerModules() {
        return Iterables.mix((Iterable[])new Iterable[]{Arrays.asList(new MasterInfoServerModule(this.webServer, this.getConfig(), this.logProvider)), super.createServerModules()});
    }

    public Iterable<AdvertisableService> getServices() {
        if (this.getDatabase().getGraph() instanceof HighlyAvailableGraphDatabase) {
            return Iterables.append((Object)new MasterInfoService(null, null), (Iterable)super.getServices());
        }
        return super.getServices();
    }

    protected Pattern[] getUriWhitelist() {
        ArrayList<Pattern> uriWhitelist = new ArrayList<Pattern>(Arrays.asList(super.getUriWhitelist()));
        if (!((Boolean)this.getConfig().get(HaSettings.ha_status_auth_enabled)).booleanValue()) {
            uriWhitelist.add(Pattern.compile("/db/manage/server/ha.*"));
        }
        return uriWhitelist.toArray(new Pattern[uriWhitelist.size()]);
    }
}

