/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.netty.channel.ChannelException;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.client.ClusterClientModule;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.StoreLogService;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.configuration.Configurator;

public class StandaloneClusterClient {
    private final LifeSupport life;
    private final Timer timer;

    private StandaloneClusterClient(LifeSupport life) {
        this.life = life;
        this.timer = new Timer(true);
        this.addShutdownHook();
        life.start();
    }

    protected void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                StandaloneClusterClient.this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.err.println("Failed to stop in a reasonable time, terminating...");
                        Runtime.getRuntime().halt(1);
                    }
                }, 4000L);
                StandaloneClusterClient.this.life.shutdown();
            }
        });
    }

    public static void main(String[] args) throws IOException {
        String propertiesFile = System.getProperty("org.neo4j.server.properties");
        File dbProperties = StandaloneClusterClient.extractDbTuningProperties(propertiesFile);
        Map<String, String> config = MapUtil.stringMap((String[])new String[0]);
        if (dbProperties != null) {
            if (!dbProperties.exists()) {
                throw new IllegalArgumentException(dbProperties + " doesn't exist");
            }
            config = StandaloneClusterClient.readFromConfigConfig(config, dbProperties);
        }
        config.putAll(Args.parse((String[])args).asMap());
        StandaloneClusterClient.verifyConfig(config);
        try {
            Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
            LogService logService = StandaloneClusterClient.logService((FileSystemAbstraction)new DefaultFileSystemAbstraction());
            LifeSupport life = new LifeSupport();
            life.add((Lifecycle)jobScheduler);
            Dependencies dependencies = new Dependencies();
            ClusterClientModule clusterClientModule = new ClusterClientModule(life, dependencies, new Monitors(), new Config(config), logService, (ElectionCredentialsProvider)new NotElectableElectionCredentialsProvider());
            new StandaloneClusterClient(life);
        }
        catch (LifecycleException e) {
            Throwable cause = Exceptions.peel((Throwable)e, (Predicate)Predicates.instanceOf(LifecycleException.class));
            if (cause instanceof ChannelException) {
                System.err.println("ERROR: " + cause.getMessage() + (cause.getCause() != null ? ", caused by:" + cause.getCause().getMessage() : ""));
            }
            System.err.println("ERROR: Unknown error");
            throw e;
        }
    }

    private static void verifyConfig(Map<String, String> config) {
        if (!config.containsKey(ClusterSettings.initial_hosts.name())) {
            System.err.println("No initial hosts to connect to supplied");
            System.exit(1);
        }
        if (!config.containsKey(ClusterSettings.server_id.name())) {
            System.err.println("No server id specified");
            System.exit(1);
        }
    }

    private static Map<String, String> readFromConfigConfig(Map<String, String> config, File propertiesFile) {
        HashMap<String, String> result = new HashMap<String, String>(config);
        Map existingConfig = MapUtil.loadStrictly((File)propertiesFile);
        for (Setting setting : new Setting[]{ClusterSettings.initial_hosts, ClusterSettings.cluster_name, ClusterSettings.cluster_server, ClusterSettings.server_id}) {
            StandaloneClusterClient.moveOver(existingConfig, result, setting);
        }
        return result;
    }

    private static void moveOver(Map<String, String> from, Map<String, String> to, Setting<?> setting) {
        String key = setting.name();
        if (from.containsKey(key)) {
            to.put(key, from.get(key));
        }
    }

    private static LogService logService(FileSystemAbstraction fileSystem) throws IOException {
        File home = new File(System.getProperty("neo4j.home"));
        String logDir = System.getProperty("org.neo4j.cluster.logdirectory", new File(new File(new File(home, "data"), "log"), "arbiter").getAbsolutePath());
        return StoreLogService.withUserLogProvider((LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out)).inStoreDirectory(fileSystem, new File(logDir));
    }

    private static File extractDbTuningProperties(String propertiesFile) {
        if (propertiesFile == null) {
            return null;
        }
        File serverConfigFile = new File(propertiesFile);
        if (!serverConfigFile.exists()) {
            return null;
        }
        Map serverConfig = MapUtil.loadStrictly((File)serverConfigFile);
        String dbTuningFile = (String)serverConfig.get(Configurator.DB_TUNING_PROPERTY_FILE_KEY);
        if (dbTuningFile == null) {
            return null;
        }
        File result = new File(dbTuningFile);
        return result.exists() ? result : null;
    }
}

