/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise.functional;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.enterprise.EnterpriseServerSettings;
import org.neo4j.server.enterprise.functional.DumpPortListenerOnNettyBindFailure;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;

public class EnterpriseServerIT {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    @Rule
    public DumpPortListenerOnNettyBindFailure dumpPorts = new DumpPortListenerOnNettyBindFailure();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToStartInHAMode() throws Throwable {
        File tuningFile = this.createNeo4jProperties();
        CommunityNeoServer server = EnterpriseServerBuilder.server().usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).withProperty(EnterpriseServerSettings.mode.name(), "HA").withProperty(Configurator.DB_TUNING_PROPERTY_FILE_KEY, tuningFile.getAbsolutePath()).persistent().build();
        try {
            server.start();
            server.getDatabase();
            Assert.assertThat((Object)server.getDatabase().getGraph(), (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(HighlyAvailableGraphDatabase.class)));
            Client client = Client.create();
            ClientResponse r = (ClientResponse)client.resource("http://localhost:" + Configurator.DEFAULT_WEBSERVER_PORT + "/db/manage/server/ha").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((long)200L, (long)r.getStatus());
            Assert.assertThat((Object)r.getEntity(String.class), (Matcher)Matchers.containsString((String)"master"));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRequireAuthorizationForHAStatusEndpoints() throws Exception {
        File tuningFile = this.createNeo4jProperties();
        CommunityNeoServer server = EnterpriseServerBuilder.server().withProperty(ServerSettings.auth_enabled.name(), "true").usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).withProperty(EnterpriseServerSettings.mode.name(), "HA").withProperty(Configurator.DB_TUNING_PROPERTY_FILE_KEY, tuningFile.getAbsolutePath()).persistent().build();
        try {
            server.start();
            server.getDatabase();
            Assert.assertThat((Object)server.getDatabase().getGraph(), (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(HighlyAvailableGraphDatabase.class)));
            Client client = Client.create();
            ClientResponse r = (ClientResponse)client.resource("http://localhost:" + Configurator.DEFAULT_WEBSERVER_PORT + "/db/manage/server/ha").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((long)401L, (long)r.getStatus());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAllowDisablingAuthorizationOnHAStatusEndpoints() throws Exception {
        File tuningFile = this.createNeo4jProperties();
        CommunityNeoServer server = EnterpriseServerBuilder.server().withProperty(ServerSettings.auth_enabled.name(), "true").withProperty(HaSettings.ha_status_auth_enabled.name(), "false").usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).withProperty(EnterpriseServerSettings.mode.name(), "HA").withProperty(Configurator.DB_TUNING_PROPERTY_FILE_KEY, tuningFile.getAbsolutePath()).persistent().build();
        try {
            server.start();
            server.getDatabase();
            Assert.assertThat((Object)server.getDatabase().getGraph(), (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(HighlyAvailableGraphDatabase.class)));
            Client client = Client.create();
            ClientResponse r = (ClientResponse)client.resource("http://localhost:" + Configurator.DEFAULT_WEBSERVER_PORT + "/db/manage/server/ha").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((long)200L, (long)r.getStatus());
            Assert.assertThat((Object)r.getEntity(String.class), (Matcher)Matchers.containsString((String)"master"));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createNeo4jProperties() throws IOException {
        File tuningFile = this.folder.newFile("neo4j-test.properties");
        try (FileOutputStream fos = new FileOutputStream(tuningFile);){
            Properties neo4jProps = new Properties();
            neo4jProps.put(ClusterSettings.server_id.name(), "1");
            neo4jProps.put(ClusterSettings.initial_hosts.name(), ":5001");
            neo4jProps.store(fos, "");
            File file = tuningFile;
            return file;
        }
    }

    @After
    public void whoListensOn5001() {
        this.dumpPorts.dumpListenersOn(5001);
    }
}

