/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.io.fs.FileUtils;

public class TxBench {
    private static GraphDatabaseService db;

    public static void main(String ... args) throws Throwable {
        int iterations = 500000;
        TxBench.bench(iterations, 1);
        TxBench.bench((long)iterations / 2L, 2);
        TxBench.bench((long)iterations / 4L, 4);
        TxBench.bench((long)iterations / 8L, 8);
    }

    public static void setup() throws IOException {
        File path = new File("/tmp/asd");
        if (path.exists()) {
            FileUtils.deleteRecursively((File)path);
        }
        db = new GraphDatabaseFactory().newEmbeddedDatabase(path.getAbsolutePath());
        try (Transaction tx = db.beginTx();){
            db.execute("CREATE INDEX ON :User(name)");
            tx.success();
        }
        tx = db.beginTx();
        var2_2 = null;
        try {
            db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    public static void teardown() {
        db.shutdown();
    }

    private static void bench(long iterations, int concurrency) throws InterruptedException, ExecutionException, IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(concurrency);
        TxBench.setup();
        long start = System.nanoTime();
        List<Future<Object>> futures = executorService.invokeAll(TxBench.workers(iterations, concurrency));
        TxBench.awaitAll(futures);
        long delta = System.nanoTime() - start;
        System.out.println("With " + concurrency + " threads: " + (double)(iterations * (long)concurrency) / ((double)delta / 1.0E9) + " ops/s");
        TxBench.teardown();
        executorService.shutdownNow();
        executorService.awaitTermination(10L, TimeUnit.SECONDS);
    }

    private static void awaitAll(List<Future<Object>> futures) throws InterruptedException, ExecutionException {
        for (Future<Object> future : futures) {
            future.get();
        }
    }

    private static List<Callable<Object>> workers(final long iterations, int numWorkers) {
        ArrayList<Callable<Object>> workers = new ArrayList<Callable<Object>>();
        for (int i = 0; i < numWorkers; ++i) {
            final Worker worker = new Worker();
            workers.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    int i = 0;
                    while ((long)i < iterations) {
                        worker.operation();
                        ++i;
                    }
                    return null;
                }
            });
        }
        return workers;
    }

    static class Worker {
        private final Map<String, Object> params = new HashMap<String, Object>();

        Worker() {
        }

        public void operation() {
            try (Transaction tx = db.beginTx();){
                this.params.put("name", ThreadLocalRandom.current().nextInt(100000));
                db.execute("MERGE (n:User {name:{name}}) RETURN n", this.params);
                tx.success();
            }
        }
    }
}

