/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.server.BaseBootstrapperTest;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.enterprise.EnterpriseBootstrapper;
import org.neo4j.server.enterprise.EnterpriseServerSettings;

public class EnterpriseBootstrapperTest
extends BaseBootstrapperTest {
    protected Bootstrapper newBootstrapper() {
        return new EnterpriseBootstrapper();
    }

    @Test
    public void shouldBeAbleToStartInSingleMode() throws Exception {
        int resultCode = CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])this.commandLineConfig(new String[]{"-c", this.configOption(EnterpriseServerSettings.mode.name(), "SINGLE")}));
        Assert.assertEquals((long)0L, (long)resultCode);
        Assert.assertNotNull((Object)this.bootstrapper.getServer());
    }

    @Test
    public void shouldBeAbleToStartInHAMode() throws Exception {
        int resultCode = CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])this.commandLineConfig(new String[]{"-c", this.configOption(EnterpriseServerSettings.mode.name(), "HA"), "-c", this.configOption(ClusterSettings.server_id.name(), "1"), "-c", this.configOption(ClusterSettings.initial_hosts.name(), "127.0.0.1:5001")}));
        Assert.assertEquals((long)0L, (long)resultCode);
        Assert.assertNotNull((Object)this.bootstrapper.getServer());
    }

    @Test
    public void shouldMigrateFixedPushStrategyInHA() throws Exception {
        CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])this.commandLineConfig(new String[]{"-c", this.configOption(EnterpriseServerSettings.mode.name(), "HA"), "-c", this.configOption(ClusterSettings.server_id.name(), "1"), "-c", this.configOption(ClusterSettings.initial_hosts.name(), "127.0.0.1:5001"), "-c", this.configOption(HaSettings.tx_push_strategy.name(), "fixed")}));
        Assert.assertEquals((Object)HaSettings.TxPushStrategy.fixed_descending, (Object)this.bootstrapper.getServer().getConfig().get(HaSettings.tx_push_strategy));
    }
}

